/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.List;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.ThrottleListener;
import jmri.jmrix.rps.RpsSensor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpsBlock
implements PropertyChangeListener,
ThrottleListener {
    float slow;
    float fast;
    SignalHead signal = null;
    RpsSensor sensor = null;
    static Hashtable<Integer, DccThrottle> throttleTable = new Hashtable();
    private static final Logger log = LoggerFactory.getLogger(RpsBlock.class);

    public RpsBlock(RpsSensor sensor, SignalHead signal, float slow, float fast) {
        this.sensor = sensor;
        this.signal = signal;
        this.slow = slow;
        this.fast = fast;
        this.sensor.addPropertyChangeListener(this);
        this.signal.addPropertyChangeListener(this);
    }

    public RpsBlock(String sensorname, String signalname, float slow, float fast) {
        this((RpsSensor)InstanceManager.sensorManagerInstance().getSensor(sensorname), InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalname), slow, fast);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.handleParameterChange(e.getPropertyName(), e.getOldValue(), e.getNewValue(), e.getSource());
    }

    void handleParameterChange(String property, Object oldState, Object newState, Object source) {
        log.debug("Change {} from {}", (Object)property, source);
        if (property.equals("Arriving")) {
            this.arriving((Integer)newState);
        } else if (property.equals("Leaving")) {
            this.leaving((Integer)newState);
        } else if (property.equals("Appearance")) {
            this.appearance();
        } else {
            log.debug("Parameter ignored");
        }
    }

    void arriving(Integer number) {
        this.acquireThrottle(number);
        this.updateCurrentThrottles();
    }

    void leaving(Integer number) {
        this.acquireThrottle(number);
    }

    void appearance() {
        this.updateCurrentThrottles();
    }

    void acquireThrottle(Integer num) {
        DccThrottle o = throttleTable.get(num);
        if (o != null) {
            return;
        }
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        Integer num = ((DccLocoAddress)t.getLocoAddress()).getNumber();
        throttleTable.put(num, t);
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
    }

    void updateCurrentThrottles() {
        List<Integer> l = this.sensor.getContents();
        if (l.size() == 0) {
            return;
        }
        if (l.size() > 1) {
            log.warn("More than one address present!");
        }
        for (int i = 0; i < l.size(); ++i) {
            Integer num = l.get(i);
            DccThrottle t = throttleTable.get(num);
            if (t != null) {
                this.updateOneThrottle(t);
                continue;
            }
            log.warn("Throttle not yet available for: {}", (Object)num);
        }
    }

    void updateOneThrottle(DccThrottle t) {
        int app = this.signal.getAppearance();
        switch (app) {
            case 1: {
                t.setSpeedSetting(0.0f);
                break;
            }
            case 16: {
                t.setSpeedSetting(this.fast);
                break;
            }
            default: {
                t.setSpeedSetting(this.slow);
            }
        }
    }

    public void dispose() {
        this.sensor.removePropertyChangeListener(this);
    }
}

