/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.PhysicalLocationReporter;
import jmri.implementation.AbstractReporter;
import jmri.jmrix.rps.Engine;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.MeasurementListener;
import jmri.jmrix.rps.Model;
import jmri.jmrix.rps.Region;
import jmri.util.PhysicalLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpsReporter
extends AbstractReporter
implements MeasurementListener {
    transient Region region;
    ArrayList<Integer> contents = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(RpsReporter.class);

    public RpsReporter(String systemName, String prefix) {
        super(systemName);
        this.region = new Region(systemName.substring(prefix.length() + 1));
        Model.instance().addRegion(this.region);
    }

    public RpsReporter(String systemName, String userName, String prefix) {
        super(systemName, userName);
        this.region = new Region(systemName.substring(prefix.length() + 1));
        Model.instance().addRegion(this.region);
    }

    @Override
    public void notify(Measurement r) {
        Point3d p = new Point3d(r.getX(), r.getY(), r.getZ());
        Integer id = Integer.valueOf(r.getReading().getId());
        if (!r.isOkPoint()) {
            return;
        }
        if (r.getZ() > 20.0 || r.getZ() < -20.0) {
            return;
        }
        log.debug("starting {}", (Object)this.getSystemName());
        if (this.region.isInside(p)) {
            this.notifyInRegion(id);
        } else {
            this.notifyOutOfRegion(id);
        }
    }

    void notifyInRegion(Integer id) {
        if (!this.contents.contains(id)) {
            this.contents.add(id);
            this.notifyArriving(id);
        }
    }

    void notifyOutOfRegion(Integer id) {
        if (this.contents.contains(id)) {
            this.contents.remove(id);
            this.notifyLeaving(id);
        }
    }

    void notifyLeaving(Integer id) {
        this.firePropertyChange("Leaving", null, id);
        this.setReport("");
    }

    void notifyArriving(Integer id) {
        this.firePropertyChange("Arriving", null, id);
        this.setReport("" + id);
    }

    @Override
    public int getState() {
        return this.contents.size();
    }

    @Override
    public void setState(int i) {
    }

    @Override
    public void dispose() {
        Model.instance().removeRegion(this.region);
        super.dispose();
    }

    public LocoAddress getLocoAddress(String rep) {
        log.debug("Parsed ID: {}", (Object)rep);
        if (rep.length() > 0) {
            try {
                int id = Integer.parseInt(rep);
                int addr = Engine.instance().getTransmitter(id).getAddress();
                return new DccLocoAddress(addr, LocoAddress.Protocol.DCC);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public PhysicalLocationReporter.Direction getDirection(String rep) {
        return PhysicalLocationReporter.Direction.ENTER;
    }

    public PhysicalLocation getPhysicalLocation() {
        return PhysicalLocation.getBeanPhysicalLocation(this);
    }

    public PhysicalLocation getPhysicalLocation(String s) {
        if (s.length() > 0) {
            try {
                int id = Integer.parseInt(s);
                Vector3d v = Engine.instance().getTransmitter(id).getLastMeasurement().getVector();
                return new PhysicalLocation(new Vector3f(v));
            }
            catch (NumberFormatException e) {
                return null;
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        return null;
    }
}

