/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.Sensor;
import jmri.jmrix.rps.Bundle;
import jmri.jmrix.rps.Distributor;
import jmri.jmrix.rps.RpsSensor;
import jmri.jmrix.rps.RpsSystemConnectionMemo;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpsSensorManager
extends AbstractSensorManager {
    private static final Logger log = LoggerFactory.getLogger(RpsSensorManager.class);

    public RpsSensorManager(RpsSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public RpsSystemConnectionMemo getMemo() {
        return (RpsSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        try {
            RpsSensor r = new RpsSensor(systemName, userName, this.getSystemPrefix());
            Distributor.instance().addMeasurementListener(r);
            return r;
        }
        catch (StringIndexOutOfBoundsException sioe) {
            throw new IllegalArgumentException("Invalid System Name: " + systemName);
        }
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        if (!prefix.equals(this.getSystemPrefix())) {
            log.warn("prefix does not match memo.prefix");
            throw new JmriException("Unable to convert " + curAddress + ", Prefix does not match");
        }
        String sys = this.getSystemPrefix() + this.typeLetter() + curAddress;
        try {
            this.validSystemNameFormat(sys);
        }
        catch (IllegalArgumentException e) {
            throw new JmriException(e.toString());
        }
        return sys;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return this.getMemo().validateSystemNameFormat(name, this, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getMemo().validSystemNameFormat(systemName, this.typeLetter());
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }
}

