/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.rps.Bundle;
import jmri.jmrix.rps.RpsReporterManager;
import jmri.jmrix.rps.RpsSensorManager;
import jmri.jmrix.rps.swing.RpsComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpsSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    private static final Logger log = LoggerFactory.getLogger(RpsSystemConnectionMemo.class);

    public RpsSystemConnectionMemo(@Nonnull String prefix, @Nonnull String name) {
        super(prefix, name);
        InstanceManager.store(this, RpsSystemConnectionMemo.class);
        InstanceManager.store(new RpsComponentFactory(this), ComponentFactory.class);
        log.debug("Created RpsSystemConnectionMemo with prefix {}", (Object)prefix);
    }

    public RpsSystemConnectionMemo() {
        this("R", "RPS");
        log.debug("Created nameless RpsSystemConnectionMemo");
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return null;
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void configureManagers() {
        InstanceManager.setSensorManager(this.getSensorManager());
        InstanceManager.setReporterManager(this.getReporterManager());
        this.register();
    }

    public RpsSensorManager getSensorManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (RpsSensorManager)this.classObjectMap.computeIfAbsent(SensorManager.class, c -> new RpsSensorManager(this));
    }

    public RpsReporterManager getReporterManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (RpsReporterManager)this.classObjectMap.computeIfAbsent(ReporterManager.class, c -> new RpsReporterManager(this));
    }

    public String validateSystemNameFormat(String name, Manager<?> manager, Locale locale) {
        manager.validateSystemNamePrefix(name, locale);
        String[] points = name.substring(manager.getSystemNamePrefix().length()).split(";");
        if (points.length < 3) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidMissingPoints", name, points.length), Bundle.getMessage(locale, "SystemNameInvalidMissingPoints", name, points.length));
        }
        for (int i = 0; i < points.length; ++i) {
            if (!points[i].startsWith("(") || !points[i].endsWith(")")) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidPointInvalid", name, points[i]), Bundle.getMessage(locale, "SystemNameInvalidPointInvalid", name, points[i]));
            }
            String[] coords = points[i].substring(1, points[i].length() - 1).split(",");
            if (coords.length != 3) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidPointInvalid", name, points[i]), Bundle.getMessage(locale, "SystemNameInvalidPointInvalid", name, points[i]));
            }
            for (int j = 0; j < 3; ++j) {
                try {
                    Double.valueOf(coords[j]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidCoordInvalid", name, points[i], coords[j]), Bundle.getMessage(locale, "SystemNameInvalidCoordInvalid", name, points[i], coords[j]));
                }
            }
        }
        return name;
    }

    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName, char type) {
        if (!systemName.startsWith(this.getSystemPrefix() + type)) {
            log.error("invalid character in header field of system name: {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        String s = systemName.substring(this.getSystemPrefix().length() + 1);
        String[] pStrings = s.split(";");
        if (pStrings.length < 3) {
            log.warn("need to have at least 3 points in {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        for (int i = 0; i < pStrings.length; ++i) {
            if (!pStrings[i].startsWith("(") || !pStrings[i].endsWith(")")) {
                log.warn("missing brackets in point {}: \"{}\"", (Object)i, (Object)pStrings[i]);
                return Manager.NameValidity.INVALID;
            }
            String coords = pStrings[i].substring(1, pStrings[i].length() - 1);
            try {
                String[] coord = coords.split(",");
                if (coord.length != 3) {
                    log.warn("need to have three coordinates in point {}: \"{}\"", (Object)i, (Object)pStrings[i]);
                    return Manager.NameValidity.INVALID;
                }
                double x = Double.valueOf(coord[0]);
                double y = Double.valueOf(coord[1]);
                double z = Double.valueOf(coord[2]);
                log.debug("succes converting systemName point {} to {},{},{}", new Object[]{i, x, y, z});
                continue;
            }
            catch (NumberFormatException e) {
                return Manager.NameValidity.INVALID;
            }
        }
        return Manager.NameValidity.VALID;
    }
}

