/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.ThrottleListener;
import jmri.jmrix.rps.Measurement;

public class Transmitter
implements ThrottleListener {
    String id;
    String rosterName;
    boolean longAddress;
    int address;
    boolean polled;
    Measurement lastMeasurement = null;
    DccThrottle throttle;
    boolean needReqThrottle = true;

    Transmitter(String id, boolean polled, int address, boolean longAddress) {
        this.setId(id);
        this.setPolled(polled);
        this.setAddress(address);
        this.setLongAddress(longAddress);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRosterName() {
        return this.rosterName;
    }

    public void setRosterName(String rosterName) {
        this.rosterName = rosterName;
    }

    public boolean isLongAddress() {
        return this.longAddress;
    }

    public void setLongAddress(boolean longAddress) {
        this.longAddress = longAddress;
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public boolean isPolled() {
        return this.polled;
    }

    public void setPolled(boolean polled) {
        this.polled = polled;
    }

    public void setLastMeasurement(Measurement last) {
        this.lastMeasurement = last;
    }

    public Measurement getLastMeasurement() {
        return this.lastMeasurement;
    }

    DccThrottle getThrottle() {
        return this.throttle;
    }

    boolean checkInit() {
        if (this.throttle != null) {
            return true;
        }
        if (!this.needReqThrottle) {
            return false;
        }
        InstanceManager.throttleManagerInstance().requestThrottle(new DccLocoAddress(this.address, this.longAddress), (ThrottleListener)this, false);
        return false;
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        this.needReqThrottle = false;
        this.throttle = t;
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
    }
}

