/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps.aligntable;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import javax.vecmath.Point3d;
import jmri.ModifiedFlag;
import jmri.jmrix.rps.Algorithms;
import jmri.jmrix.rps.Engine;
import jmri.jmrix.rps.Receiver;
import jmri.jmrix.rps.swing.LoadStorePanel;
import jmri.swing.RowSorterUtil;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlignTablePane
extends JPanel {
    static ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrix.rps.aligntable.AlignTableBundle");
    AlignModel alignModel = null;
    ModifiedFlag flag;
    LoadStorePanel loadStore;
    JTextField num = new JTextField(4);
    JTextField vsound = new JTextField(8);
    JTextField offset = new JTextField(4);
    JComboBox<String> algorithmBox = Algorithms.algorithmBox();
    private static final Logger log = LoggerFactory.getLogger(AlignTablePane.class);

    public AlignTablePane(ModifiedFlag flag) {
        this.flag = flag;
    }

    public void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.alignModel = new AlignModel();
        JTable alignTable = new JTable(this.alignModel);
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        alignTable.setDefaultRenderer(JButton.class, buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        alignTable.setDefaultEditor(JButton.class, buttonEditor);
        TableRowSorter<AlignModel> sorter = new TableRowSorter<AlignModel>(this.alignModel);
        RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
        alignTable.setRowSelectionAllowed(false);
        alignTable.setPreferredScrollableViewportSize(new Dimension(580, 80));
        JScrollPane scrollPane = new JScrollPane(alignTable);
        this.add(scrollPane);
        JPanel p = new JPanel(){

            @Override
            public Dimension getMaximumSize() {
                int height = this.getPreferredSize().height;
                int width = super.getMaximumSize().width;
                return new Dimension(width, height);
            }
        };
        p.setLayout(new FlowLayout());
        p.add(new JLabel(rb.getString("LabelNumCol")));
        this.num.setText("" + Engine.instance().getMaxReceiverNumber());
        p.add(this.num);
        JButton b = new JButton(rb.getString("ButtonSet"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Engine.instance().setMaxReceiverNumber(Integer.parseInt(AlignTablePane.this.num.getText()));
                AlignTablePane.this.flag.setModifiedFlag(true);
                AlignTablePane.this.alignModel.fireTableStructureChanged();
            }
        });
        p.add(b);
        this.add(p);
        p = new JPanel(){

            @Override
            public Dimension getMaximumSize() {
                int height = this.getPreferredSize().height;
                int width = super.getMaximumSize().width;
                return new Dimension(width, height);
            }
        };
        p.setLayout(new FlowLayout());
        p.add(new JLabel(rb.getString("LabelVSound")));
        this.vsound.setText("" + Engine.instance().getVSound());
        p.add(this.vsound);
        p.add(new JLabel(rb.getString("LabelOffset")));
        this.offset.setText("" + Engine.instance().getOffset());
        p.add(this.offset);
        p.add(new JLabel(rb.getString("LabelAlgorithm")));
        p.add(this.algorithmBox);
        b = new JButton(rb.getString("ButtonSet"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Engine.instance().setOffset(Integer.parseInt(AlignTablePane.this.offset.getText()));
                Engine.instance().setVSound(Double.parseDouble(AlignTablePane.this.vsound.getText()));
                Engine.instance().setAlgorithm((String)AlignTablePane.this.algorithmBox.getSelectedItem());
                AlignTablePane.this.flag.setModifiedFlag(true);
            }
        });
        p.add(b);
        this.add(p);
        this.loadStore = new LoadStorePanel(){

            @Override
            public void load() {
                super.load();
                AlignTablePane.this.alignModel.fireTableStructureChanged();
                AlignTablePane.this.flag.setModifiedFlag(true);
            }

            @Override
            public void storeDefault() {
                super.storeDefault();
                AlignTablePane.this.flag.setModifiedFlag(false);
            }
        };
        this.add(this.loadStore);
        Engine.instance().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("vSound")) {
                    AlignTablePane.this.vsound.setText("" + e.getNewValue());
                }
            }
        });
    }

    void storeDefault() {
        this.loadStore.storeDefault();
        this.flag.setModifiedFlag(false);
    }

    public class AlignModel
    extends AbstractTableModel {
        private static final int NUMCOL = 0;
        private static final int XCOL = 1;
        private static final int YCOL = 2;
        private static final int ZCOL = 3;
        private static final int LASTTIMECOL = 4;
        private static final int ACTIVECOL = 5;
        private static final int MINTIMECOL = 6;
        private static final int MAXTIMECOL = 7;
        private static final int LAST = 7;

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public int getRowCount() {
            return Engine.instance().getMaxReceiverNumber();
        }

        @Override
        public String getColumnName(int c) {
            switch (c) {
                case 0: {
                    return rb.getString("TitleColNum");
                }
                case 1: {
                    return rb.getString("TitleColX");
                }
                case 2: {
                    return rb.getString("TitleColY");
                }
                case 3: {
                    return rb.getString("TitleColZ");
                }
                case 4: {
                    return rb.getString("TitleColLast");
                }
                case 5: {
                    return rb.getString("TitleColActive");
                }
                case 6: {
                    return rb.getString("TitleColMin");
                }
                case 7: {
                    return rb.getString("TitleColMax");
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 1 || c == 2 || c == 3) {
                return Double.class;
            }
            if (c == 0) {
                return Integer.class;
            }
            if (c == 5) {
                return Boolean.class;
            }
            if (c == 6 || c == 7 || c == 4) {
                return Integer.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 1 || c == 2 || c == 3 || c == 5 || c == 6 || c == 7;
        }

        @Override
        public Object getValueAt(int r, int c) {
            switch (c) {
                case 0: {
                    return r + 1;
                }
                case 1: {
                    Receiver rc = Engine.instance().getReceiver(r + 1);
                    if (rc == null) {
                        return null;
                    }
                    return rc.getPosition().x;
                }
                case 2: {
                    Receiver rc = Engine.instance().getReceiver(r + 1);
                    if (rc == null) {
                        return null;
                    }
                    return rc.getPosition().y;
                }
                case 3: {
                    Receiver rc = Engine.instance().getReceiver(r + 1);
                    if (rc == null) {
                        return null;
                    }
                    return rc.getPosition().z;
                }
                case 5: {
                    Receiver rc = Engine.instance().getReceiver(r + 1);
                    if (rc == null) {
                        return null;
                    }
                    return rc.isActive();
                }
                case 4: {
                    Receiver rc = Engine.instance().getReceiver(r + 1);
                    if (rc == null) {
                        return null;
                    }
                    return rc.getLastTime();
                }
                case 6: {
                    Receiver rc = Engine.instance().getReceiver(r + 1);
                    if (rc == null) {
                        return null;
                    }
                    return rc.getMinTime();
                }
                case 7: {
                    Receiver rc = Engine.instance().getReceiver(r + 1);
                    if (rc == null) {
                        return null;
                    }
                    return rc.getMaxTime();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object val, int r, int c) {
            switch (c) {
                case 1: {
                    Receiver rc = Engine.instance().getReceiver(r + 1);
                    if (rc == null) {
                        rc = new Receiver(new Point3d(0.0, 0.0, 0.0));
                        Engine.instance().setReceiver(r + 1, rc);
                    }
                    Point3d p = rc.getPosition();
                    p.x = (Double)val;
                    Engine.instance().setReceiverPosition(r + 1, p);
                    AlignTablePane.this.flag.setModifiedFlag(true);
                    break;
                }
                case 2: {
                    Receiver rc = Engine.instance().getReceiver(r + 1);
                    if (rc == null) {
                        rc = new Receiver(new Point3d(0.0, 0.0, 0.0));
                        Engine.instance().setReceiver(r + 1, rc);
                    }
                    Point3d p = rc.getPosition();
                    p.y = (Double)val;
                    Engine.instance().setReceiverPosition(r + 1, p);
                    AlignTablePane.this.flag.setModifiedFlag(true);
                    break;
                }
                case 3: {
                    Receiver rc = Engine.instance().getReceiver(r + 1);
                    if (rc == null) {
                        rc = new Receiver(new Point3d(0.0, 0.0, 0.0));
                        Engine.instance().setReceiver(r + 1, rc);
                    }
                    Point3d p = rc.getPosition();
                    p.z = (Double)val;
                    Engine.instance().setReceiverPosition(r + 1, p);
                    AlignTablePane.this.flag.setModifiedFlag(true);
                    break;
                }
                case 5: {
                    Receiver rc = Engine.instance().getReceiver(r + 1);
                    if (rc == null) {
                        rc = new Receiver(new Point3d(0.0, 0.0, 0.0));
                        Engine.instance().setReceiver(r + 1, rc);
                    }
                    rc.setActive(((Boolean)val).equals(Boolean.TRUE));
                    AlignTablePane.this.flag.setModifiedFlag(true);
                    break;
                }
                case 6: {
                    Receiver rc = Engine.instance().getReceiver(r + 1);
                    if (rc == null) {
                        rc = new Receiver(new Point3d(0.0, 0.0, 0.0));
                        Engine.instance().setReceiver(r + 1, rc);
                    }
                    int min = (Integer)val;
                    Engine.instance().getReceiver(r + 1).setMinTime(min);
                    AlignTablePane.this.flag.setModifiedFlag(true);
                    break;
                }
                case 7: {
                    Receiver rc = Engine.instance().getReceiver(r + 1);
                    if (rc == null) {
                        rc = new Receiver(new Point3d(0.0, 0.0, 0.0));
                        Engine.instance().setReceiver(r + 1, rc);
                    }
                    int max = (Integer)val;
                    Engine.instance().getReceiver(r + 1).setMaxTime(max);
                    AlignTablePane.this.flag.setModifiedFlag(true);
                    break;
                }
                default: {
                    log.error("setValueAt of column {}", (Object)c);
                }
            }
        }
    }
}

