/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps.reversealign;

import java.awt.FlowLayout;
import java.io.File;
import java.text.NumberFormat;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.vecmath.Point3d;
import jmri.jmrit.XmlFile;
import jmri.jmrix.rps.Algorithms;
import jmri.jmrix.rps.Calculator;
import jmri.jmrix.rps.Constants;
import jmri.jmrix.rps.Distributor;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.PositionFile;
import jmri.jmrix.rps.Reading;
import jmri.jmrix.rps.ReadingListener;
import jmri.jmrix.rps.RpsSystemConnectionMemo;
import jmri.jmrix.rps.reversealign.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlignmentPanel
extends JPanel
implements ReadingListener,
Constants {
    RpsSystemConnectionMemo memo;
    JFileChooser fci = XmlFile.userFileChooser();
    JTextField x1l = new JTextField(5);
    JTextField y1l = new JTextField(5);
    JTextField z1l = new JTextField(5);
    JTextField stat1 = new JTextField(5);
    JTextField x2l = new JTextField(5);
    JTextField y2l = new JTextField(5);
    JTextField z2l = new JTextField(5);
    JTextField stat2 = new JTextField(5);
    JTextField x3l = new JTextField(5);
    JTextField y3l = new JTextField(5);
    JTextField z3l = new JTextField(5);
    JTextField stat3 = new JTextField(5);
    JTextField x4l = new JTextField(5);
    JTextField y4l = new JTextField(5);
    JTextField z4l = new JTextField(5);
    JTextField stat4 = new JTextField(5);
    JTextField vs = new JTextField(5);
    NumberFormat nf;
    JComboBox<String> algorithm;
    Line[] lines;
    JButton calc = new JButton("Calculate");
    private static final Logger log = LoggerFactory.getLogger(AlignmentPanel.class);

    public AlignmentPanel(RpsSystemConnectionMemo _memo) {
        this.memo = _memo;
        Distributor.instance().addReadingListener(this);
        this.nf = NumberFormat.getInstance();
        this.nf.setMinimumFractionDigits(1);
        this.nf.setMaximumFractionDigits(1);
        this.nf.setGroupingUsed(false);
    }

    void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.lines = new Line[8];
        for (int i = 0; i < 8; ++i) {
            this.lines[i] = new Line();
            this.add(this.lines[i]);
        }
        JPanel p = new JPanel();
        this.algorithm = Algorithms.algorithmBox();
        p.add(this.algorithm);
        p.add(new JLabel("Vs: "));
        p.add(this.vs);
        this.vs.setText("0.01345");
        p.add(this.calc);
        this.calc.addActionListener(event -> this.calculate());
        this.add(p);
        p = new JPanel();
        p.add(new JLabel("X:"));
        p.add(this.x1l);
        p.add(this.x2l);
        p.add(this.x3l);
        p.add(this.x4l);
        this.add(p);
        p = new JPanel();
        p.add(new JLabel("Y:"));
        p.add(this.y1l);
        p.add(this.y2l);
        p.add(this.y3l);
        p.add(this.y4l);
        this.add(p);
        p = new JPanel();
        p.add(new JLabel("Z:"));
        p.add(this.z1l);
        p.add(this.z2l);
        p.add(this.z3l);
        p.add(this.z4l);
        this.add(p);
        p = new JPanel();
        p.add(new JLabel("S:"));
        p.add(this.stat1);
        p.add(this.stat2);
        p.add(this.stat3);
        p.add(this.stat4);
        this.add(p);
        p = new JPanel();
        JButton b1 = new JButton(Bundle.getMessage("ButtonStore_"));
        b1.addActionListener(event -> this.store());
        p.add(b1);
        b1 = new JButton(Bundle.getMessage("ButtonLoad_"));
        b1.addActionListener(event -> this.load());
        p.add(b1);
        this.add(new JSeparator());
        this.add(p);
        this.dummy3();
    }

    void load() {
        try {
            this.fci.rescanCurrentDirectory();
            int retVal = this.fci.showOpenDialog(this);
            if (retVal == 0) {
                int i;
                File file = this.fci.getSelectedFile();
                if (log.isInfoEnabled()) {
                    log.info("located file {} for load", (Object)file);
                }
                PositionFile pf = new PositionFile();
                pf.loadFile(file);
                for (i = 0; i < 8; ++i) {
                    Point3d p = pf.getCalibrationPosition(i);
                    if (p != null) {
                        this.lines[i].setPoint(p);
                        continue;
                    }
                    this.lines[i].setPoint(new Point3d(0.0, 0.0, 0.0));
                }
                for (i = 0; i < 8; ++i) {
                    Reading r = pf.getCalibrationReading(i);
                    this.lines[i].reset();
                    if (r == null) continue;
                    this.lines[i].setReading(r);
                }
            } else {
                log.info("load cancelled in open dialog");
            }
        }
        catch (Exception e) {
            log.error("exception during load: ", (Throwable)e);
        }
    }

    void store() {
        try {
            this.fci.rescanCurrentDirectory();
            int retVal = this.fci.showSaveDialog(this);
            if (retVal == 0) {
                File file = this.fci.getSelectedFile();
                if (log.isInfoEnabled()) {
                    log.info("located file {} for load", (Object)file);
                }
                PositionFile pf = new PositionFile();
                pf.prepare();
                pf.setReceiver(1, this.getPoint(this.x1l, this.y1l, this.z1l), true);
                pf.setReceiver(2, this.getPoint(this.x2l, this.y1l, this.z2l), true);
                pf.setReceiver(3, this.getPoint(this.x3l, this.y1l, this.z3l), true);
                pf.setReceiver(4, this.getPoint(this.x4l, this.y1l, this.z4l), true);
                for (int i = 0; i < 8; ++i) {
                    Point3d p = this.lines[i].getPoint();
                    p.z = -p.z;
                    pf.setCalibrationPoint(p, this.lines[i].getReading());
                }
                pf.store(file);
            } else {
                log.info("load cancelled in open dialog");
            }
        }
        catch (Exception e) {
            log.error("exception during load: ", (Throwable)e);
        }
    }

    Point3d getPoint(JTextField x, JTextField y, JTextField z) {
        float xval = Float.parseFloat(x.getText());
        float yval = Float.parseFloat(y.getText());
        float zval = Float.parseFloat(z.getText());
        return new Point3d((double)xval, (double)yval, (double)zval);
    }

    void dummy1() {
        this.lines[0].xl.setText("19");
        this.lines[0].yl.setText("83.5");
        this.lines[0].zl.setText("12.1");
        this.lines[0].s1 = 1100.0;
        this.lines[1].xl.setText("1.3");
        this.lines[1].yl.setText("25");
        this.lines[1].zl.setText("14.2");
        this.lines[1].s1 = 4304.0;
        this.lines[2].xl.setText("35.9");
        this.lines[2].yl.setText("1.5");
        this.lines[2].zl.setText("13.4");
        this.lines[2].s1 = 5634.0;
        this.lines[3].xl.setText("57.1");
        this.lines[3].yl.setText("21.5");
        this.lines[3].zl.setText("13.8");
        this.lines[3].s1 = 4782.0;
    }

    void dummy2() {
        this.lines[0].xl.setText("14.2");
        this.lines[0].yl.setText("21.4");
        this.lines[0].zl.setText("2");
        this.lines[0].s1l.setText("1274.1");
        this.lines[0].s2l.setText("3699.3");
        this.lines[0].s3l.setText("4764.2");
        this.lines[0].s4l.setText("4363.3");
        this.lines[1].xl.setText("58.5");
        this.lines[1].yl.setText("14");
        this.lines[1].zl.setText("2");
        this.lines[1].s1l.setText("4389.4");
        this.lines[1].s2l.setText("1328.3");
        this.lines[1].s3l.setText("2326.8");
        this.lines[1].s4l.setText("3340.8");
        this.lines[2].xl.setText("50.1");
        this.lines[2].yl.setText("3.8");
        this.lines[2].zl.setText("2");
        this.lines[2].s1l.setText("4005.7");
        this.lines[2].s2l.setText("1104");
        this.lines[2].s3l.setText("3166");
        this.lines[2].s4l.setText("4148.3");
        this.lines[3].xl.setText("70.3");
        this.lines[3].yl.setText("47.4");
        this.lines[3].zl.setText("2");
        this.lines[3].s1l.setText("5741");
        this.lines[3].s2l.setText("3666.8");
        this.lines[3].s3l.setText("1652");
        this.lines[3].s4l.setText("1294.2");
    }

    void dummy3() {
        int i = 0;
        this.lines[i].xl.setText("70.1");
        this.lines[i].yl.setText("21.2");
        this.lines[i].zl.setText("2");
        this.lines[i].s1l.setText("1282");
        this.lines[i].s2l.setText("3818");
        this.lines[i].s3l.setText("5209");
        this.lines[i].s4l.setText("4677");
        i = 1;
        this.lines[i].xl.setText("25.6");
        this.lines[i].yl.setText("14.1");
        this.lines[i].zl.setText("2");
        this.lines[i].s1l.setText("4412");
        this.lines[i].s2l.setText("1334");
        this.lines[i].s3l.setText("1956");
        this.lines[i].s4l.setText("3362");
        i = 2;
        this.lines[i].xl.setText("32.2");
        this.lines[i].yl.setText("4.2");
        this.lines[i].zl.setText("2");
        this.lines[i].s1l.setText("4010");
        this.lines[i].s2l.setText("1119");
        this.lines[i].s3l.setText("2876");
        this.lines[i].s4l.setText("4177");
        i = 3;
        this.lines[i].xl.setText("14.2");
        this.lines[i].yl.setText("47.4");
        this.lines[i].zl.setText("2");
        this.lines[i].s1l.setText("5762");
        this.lines[i].s2l.setText("3634");
        this.lines[i].s3l.setText("1607");
        this.lines[i].s4l.setText("1340");
        i = 4;
        this.lines[i].xl.setText("70.1");
        this.lines[i].yl.setText("21.2");
        this.lines[i].zl.setText("7.5");
        this.lines[i].s1l.setText("1083");
        this.lines[i].s2l.setText("3765");
        this.lines[i].s3l.setText("5247");
        this.lines[i].s4l.setText("4216");
        i = 5;
        this.lines[i].xl.setText("25.6");
        this.lines[i].yl.setText("14.1");
        this.lines[i].zl.setText("7.5");
        this.lines[i].s1l.setText("4328");
        this.lines[i].s2l.setText("1091");
        this.lines[i].s3l.setText("2312");
        this.lines[i].s4l.setText("3333");
        i = 6;
        this.lines[i].xl.setText("32.2");
        this.lines[i].yl.setText("4.2");
        this.lines[i].zl.setText("7.5");
        this.lines[i].s1l.setText("3959");
        this.lines[i].s2l.setText("831");
        this.lines[i].s3l.setText("3165");
        this.lines[i].s4l.setText("4148");
        i = 7;
        this.lines[i].xl.setText("14.2");
        this.lines[i].yl.setText("47.4");
        this.lines[i].zl.setText("7.5");
        this.lines[i].s1l.setText("5741");
        this.lines[i].s2l.setText("3599");
        this.lines[i].s3l.setText("1509");
        this.lines[i].s4l.setText("1119");
    }

    @Override
    public void notify(Reading r) {
        for (Line line : this.lines) {
            line.update(r);
        }
    }

    double getVSound() {
        try {
            return Double.parseDouble(this.vs.getText());
        }
        catch (Exception e) {
            this.vs.setText("0.0344");
            return 0.0344;
        }
    }

    void calculate() {
        int offset = 0;
        Point3d[] points = new Point3d[8];
        for (int i = 0; i < 8; ++i) {
            points[i] = this.lines[i].getPoint();
        }
        Reading r = this.getReading(8, 0);
        Calculator c = Algorithms.newCalculator(points, this.getVSound(), offset, (String)Objects.requireNonNull(this.algorithm.getSelectedItem()));
        Measurement m = c.convert(r);
        this.x1l.setText(this.nf.format(m.getX()));
        this.y1l.setText(this.nf.format(m.getY()));
        this.z1l.setText(this.nf.format(-m.getZ()));
        this.stat1.setText(m.textCode());
        r = this.getReading(8, 1);
        c = Algorithms.newCalculator(points, this.getVSound(), offset, (String)this.algorithm.getSelectedItem());
        m = c.convert(r);
        this.x2l.setText(this.nf.format(m.getX()));
        this.y2l.setText(this.nf.format(m.getY()));
        this.z2l.setText(this.nf.format(-m.getZ()));
        this.stat2.setText(m.textCode());
        r = this.getReading(8, 2);
        c = Algorithms.newCalculator(points, this.getVSound(), offset, (String)this.algorithm.getSelectedItem());
        m = c.convert(r);
        this.x3l.setText(this.nf.format(m.getX()));
        this.y3l.setText(this.nf.format(m.getY()));
        this.z3l.setText(this.nf.format(-m.getZ()));
        this.stat3.setText(m.textCode());
        r = this.getReading(8, 3);
        c = Algorithms.newCalculator(points, this.getVSound(), offset, (String)this.algorithm.getSelectedItem());
        m = c.convert(r);
        this.x4l.setText(this.nf.format(m.getX()));
        this.y4l.setText(this.nf.format(m.getY()));
        this.z4l.setText(this.nf.format(-m.getZ()));
        this.stat4.setText(m.textCode());
    }

    Reading getReading(int n, int index) {
        double[] vals = new double[8];
        for (int i = 0; i < 8; ++i) {
            vals[i] = this.lines[i].getTime(index);
        }
        return new Reading("(from alignment)", vals);
    }

    class Line
    extends JPanel {
        JCheckBox acquire = new JCheckBox("Acquire");
        JTextField xl = new JTextField(5);
        JTextField yl = new JTextField(5);
        JTextField zl = new JTextField(5);
        JTextField nl = new JTextField(5);
        long n;
        JTextField s1l = new JTextField(5);
        JTextField s2l = new JTextField(5);
        JTextField s3l = new JTextField(5);
        JTextField s4l = new JTextField(5);
        JTextField s5l = new JTextField(5);
        JTextField s6l = new JTextField(5);
        double s1;
        double s2;
        double s3;
        double s4;
        double s5;
        double s6;

        Line() {
            this.setLayout(new FlowLayout());
            this.add(new JLabel("Position:"));
            this.add(this.xl);
            this.add(this.yl);
            this.add(this.zl);
            this.add(this.acquire);
            JButton reset = new JButton("Reset");
            reset.addActionListener(event -> this.reset());
            this.add(reset);
            this.add(new JLabel("n:"));
            this.add(this.nl);
            this.add(new JLabel("Times:"));
            this.add(this.s1l);
            this.add(this.s2l);
            this.add(this.s3l);
            this.add(this.s4l);
            this.n = 0L;
            this.s4 = 0.0;
            this.s3 = 0.0;
            this.s2 = 0.0;
            this.s1 = 0.0;
        }

        double getTime(int i) {
            switch (i) {
                case 0: {
                    return Float.valueOf(this.s1l.getText()).intValue();
                }
                case 1: {
                    return Float.valueOf(this.s2l.getText()).intValue();
                }
                case 2: {
                    return Float.valueOf(this.s3l.getText()).intValue();
                }
                case 3: {
                    return Float.valueOf(this.s4l.getText()).intValue();
                }
            }
            return -1.0;
        }

        Reading getReading() {
            return new Reading("(from alignment)", new double[]{this.getTime(0), this.getTime(1), this.getTime(2), this.getTime(3)});
        }

        void reset() {
            this.nl.setText("0");
            this.n = 0L;
            this.s1l.setText("0");
            this.s1 = 0.0;
            this.s2l.setText("0");
            this.s2 = 0.0;
            this.s3l.setText("0");
            this.s3 = 0.0;
            this.s4l.setText("0");
            this.s4 = 0.0;
        }

        void setReading(Reading r) {
            this.s1l.setText("" + r.getValue(0));
            this.s2l.setText("" + r.getValue(1));
            this.s3l.setText("" + r.getValue(2));
            this.s4l.setText("" + r.getValue(3));
        }

        void update(Reading r) {
            if (Math.abs(r.getValue(0)) > 40000.0 || Math.abs(r.getValue(1)) > 40000.0 || Math.abs(r.getValue(2)) > 40000.0 || Math.abs(r.getValue(3)) > 40000.0) {
                return;
            }
            if (this.acquire.isSelected()) {
                this.s1 = ((double)this.n * this.s1 + r.getValue(0)) / (double)(this.n + 1L);
                this.s1l.setText(AlignmentPanel.this.nf.format(this.s1));
                this.s2 = ((double)this.n * this.s2 + r.getValue(1)) / (double)(this.n + 1L);
                this.s2l.setText(AlignmentPanel.this.nf.format(this.s2));
                this.s3 = ((double)this.n * this.s3 + r.getValue(2)) / (double)(this.n + 1L);
                this.s3l.setText(AlignmentPanel.this.nf.format(this.s3));
                this.s4 = ((double)this.n * this.s4 + r.getValue(3)) / (double)(this.n + 1L);
                this.s4l.setText(AlignmentPanel.this.nf.format(this.s4));
                ++this.n;
                this.nl.setText("" + this.n);
            }
        }

        Point3d getPoint() {
            float xval = Float.parseFloat(this.xl.getText());
            float yval = Float.parseFloat(this.yl.getText());
            float zval = -Float.parseFloat(this.zl.getText());
            return new Point3d((double)xval, (double)yval, (double)zval);
        }

        void setPoint(Point3d p) {
            this.xl.setText("" + p.x);
            this.yl.setText("" + p.y);
            this.zl.setText("" + p.z);
        }
    }
}

