/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps.swing;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import jmri.jmrix.rps.Distributor;
import jmri.jmrix.rps.Reading;
import jmri.jmrix.rps.ReadingListener;
import jmri.jmrix.rps.RpsSystemConnectionMemo;
import jmri.util.swing.JmriJFileChooser;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvExportAction
extends AbstractAction
implements ReadingListener {
    RpsSystemConnectionMemo memo = null;
    JFrame mParent;
    boolean logging = false;
    CSVPrinter str;
    JFileChooser fileChooser;
    private static final Logger log = LoggerFactory.getLogger(CsvExportAction.class);

    public CsvExportAction(String actionName, RpsSystemConnectionMemo _memo) {
        super(actionName);
        this.memo = _memo;
    }

    public CsvExportAction(RpsSystemConnectionMemo _memo) {
        this("Start CSV Export Reading...", _memo);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.logging) {
            this.stopLogging(e);
        } else {
            this.startLogging(e);
        }
    }

    void stopLogging(ActionEvent e) {
        Distributor.instance().removeReadingListener(this);
        ((JMenuItem)e.getSource()).setText("Start CSV Export Reading...");
        this.logging = false;
        try {
            this.str.flush();
            this.str.close();
        }
        catch (IOException ex) {
            log.error("Error closing file: {}", (Throwable)ex);
        }
    }

    void startLogging(ActionEvent e) {
        log.debug("{}", (Object)e);
        ((JMenuItem)e.getSource()).setText("Stop CSV Export Reading...");
        if (this.fileChooser == null) {
            this.fileChooser = new JmriJFileChooser();
        } else {
            this.fileChooser.rescanCurrentDirectory();
        }
        int retVal = this.fileChooser.showSaveDialog(this.mParent);
        if (retVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            log.debug("start to log to file {}", (Object)file);
            try {
                this.str = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), CSVFormat.DEFAULT);
                Distributor.instance().addReadingListener(this);
                this.logging = true;
            }
            catch (IOException ex) {
                log.error("Error opening file: {}", (Throwable)ex);
            }
        }
    }

    @Override
    public void notify(Reading r) {
        if (!this.logging || this.str == null) {
            return;
        }
        ArrayList<String> values = new ArrayList<String>(r.getNValues() + 1);
        values.add(r.getId());
        values.addAll(Arrays.asList(new double[][]{r.getValues()}));
        try {
            this.str.printRecord(values);
        }
        catch (IOException ex) {
            log.error("Error writing file: {}", (Throwable)ex);
        }
    }
}

