/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps.swing;

import java.io.File;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import jmri.jmrit.XmlFile;
import jmri.jmrix.rps.Engine;
import jmri.jmrix.rps.PositionFile;
import jmri.jmrix.rps.swing.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadStorePanel
extends JPanel {
    @GuardedBy(value="this")
    JFileChooser fci = XmlFile.userFileChooser();
    private static final Logger log = LoggerFactory.getLogger(LoadStorePanel.class);

    public LoadStorePanel() {
        JButton b1 = new JButton(Bundle.getMessage("ButtonSetDefaults"));
        b1.setToolTipText(Bundle.getMessage("HintSetDefaults"));
        b1.addActionListener(event -> this.storeDefault());
        this.add(b1);
        b1 = new JButton(Bundle.getMessage("ButtonStore_"));
        b1.setToolTipText(Bundle.getMessage("HintStore"));
        b1.addActionListener(event -> this.store());
        this.add(b1);
        b1 = new JButton(Bundle.getMessage("ButtonLoad_"));
        b1.setToolTipText(Bundle.getMessage("HintLoad"));
        b1.addActionListener(event -> this.load());
        this.add(b1);
    }

    public synchronized void load() {
        try {
            this.fci.rescanCurrentDirectory();
            int retVal = this.fci.showOpenDialog(this);
            if (retVal == 0) {
                File file = this.fci.getSelectedFile();
                log.debug("located file {} for load", (Object)file);
                Engine.instance().loadAlignment(file);
            } else {
                log.debug("load cancelled in open dialog");
            }
        }
        catch (Exception e) {
            log.error("exception during load: ", (Throwable)e);
        }
    }

    public synchronized void store() {
        try {
            this.fci.rescanCurrentDirectory();
            int retVal = this.fci.showSaveDialog(this);
            if (retVal == 0) {
                File file = this.fci.getSelectedFile();
                log.debug("located file {} for store", (Object)file);
                Engine.instance().storeAlignment(file);
            } else {
                log.debug("load cancelled in open dialog");
            }
        }
        catch (Exception e) {
            log.error("exception during store: ", (Throwable)e);
        }
    }

    public void storeDefault() {
        try {
            File file = new File(PositionFile.defaultFilename());
            log.debug("located file {} for store", (Object)file);
            Engine.instance().storeAlignment(file);
        }
        catch (Exception e) {
            log.error("exception during storeDefault: ", (Throwable)e);
        }
    }
}

