/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps.swing.debugger;

import java.awt.FlowLayout;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jmri.jmrix.rps.Distributor;
import jmri.jmrix.rps.Engine;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.MeasurementListener;
import jmri.jmrix.rps.Reading;
import jmri.jmrix.rps.ReadingListener;
import jmri.jmrix.rps.RpsSystemConnectionMemo;
import jmri.jmrix.rps.swing.CsvExportAction;
import jmri.jmrix.rps.swing.CsvExportMeasurementAction;
import jmri.jmrix.rps.swing.debugger.DebuggerTimePane;
import jmri.util.IntlUtilities;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJFileChooser;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerFrame
extends JmriJFrame
implements ReadingListener,
MeasurementListener {
    private RpsSystemConnectionMemo memo = null;
    private NumberFormat nf;
    private JComboBox<String> mode;
    private final JTextField x = new JTextField(18);
    private final JTextField y = new JTextField(18);
    private final JTextField z = new JTextField(18);
    private final JLabel code = new JLabel();
    private final JTextField id = new JTextField(5);
    private final DebuggerTimePane timep = new DebuggerTimePane();
    private final int NUMSENSORS;
    private CSVParser readingInput = null;
    final JFileChooser readingFileChooser = new JmriJFileChooser("rps/readings.csv");
    private CSVParser measurementInput = null;
    final JFileChooser measurementFileChooser = new JmriJFileChooser("rps/positions.csv");
    private static final Logger log = LoggerFactory.getLogger(DebuggerFrame.class);

    public DebuggerFrame(RpsSystemConnectionMemo rpsMemo) {
        this.memo = rpsMemo;
        this.NUMSENSORS = Engine.instance().getMaxReceiverNumber();
        this.setTitle(this.title());
    }

    protected final String title() {
        return "RPS Debugger";
    }

    @Override
    public void dispose() {
        Distributor.instance().removeReadingListener(this);
        Distributor.instance().removeMeasurementListener(this);
        super.dispose();
    }

    @Override
    public void initComponents() {
        this.nf = NumberFormat.getInstance();
        this.nf.setMinimumFractionDigits(1);
        this.nf.setMaximumFractionDigits(1);
        this.nf.setGroupingUsed(false);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(new JLabel("Time measurements: "));
        this.timep.initComponents();
        JScrollPane sc = new JScrollPane(this.timep);
        p.add(sc);
        JPanel p5 = new JPanel();
        p5.setLayout(new FlowLayout());
        p5.add(new JLabel("Id: "));
        p5.add(this.id);
        p.add(p5);
        this.getContentPane().add(p);
        this.getContentPane().add(new JSeparator());
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(new JLabel("Results:"));
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(new JLabel("X:"));
        p1.add(this.x);
        p.add(p1);
        p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(new JLabel("Y:"));
        p1.add(this.y);
        p.add(p1);
        p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(new JLabel("Z:"));
        p1.add(this.z);
        p.add(p1);
        p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(new JLabel("Code:"));
        p1.add(this.code);
        p.add(p1);
        this.getContentPane().add(p);
        this.getContentPane().add(new JSeparator());
        p = new JPanel();
        this.mode = new JComboBox<String>(new String[]{"From time fields", "from X,Y,Z fields", "from time file", "from X,Y,Z file"});
        p.add(this.mode);
        p.setLayout(new FlowLayout());
        JButton doButton = new JButton("Do Once");
        doButton.addActionListener(e -> this.doOnce());
        p.add(doButton);
        this.getContentPane().add(p);
        Distributor.instance().addReadingListener(this);
        Distributor.instance().addMeasurementListener(this);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        fileMenu.add(new CsvExportAction("Export Readings as CSV...", this.memo));
        fileMenu.add(new CsvExportMeasurementAction("Export Measurements as CSV...", this.memo));
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrix.rps.swing.debugger.DebuggerFrame", true);
        this.pack();
    }

    private void doOnce() {
        try {
            switch (this.mode.getSelectedIndex()) {
                case 0: {
                    this.doReadingFromTimeFields();
                    break;
                }
                case 1: {
                    this.doMeasurementFromPositionFields();
                    break;
                }
                case 2: {
                    this.doLoadReadingFromFile();
                    this.doReadingFromTimeFields();
                    break;
                }
                case 3: {
                    this.doLoadMeasurementFromFile();
                    break;
                }
                default: {
                    log.error("Did not expect selected mode {}", (Object)this.mode.getSelectedIndex());
                    break;
                }
            }
        }
        catch (IOException e) {
            log.error("exception ", (Throwable)e);
        }
    }

    private void doLoadReadingFromFile() throws IOException {
        if (this.readingInput == null) {
            this.readingInput = this.getParser(this.readingFileChooser);
        }
        if (this.readingInput.getRecords().isEmpty()) {
            this.readingInput = this.getParser(this.readingFileChooser);
            if (this.readingInput.getRecords().isEmpty()) {
                throw new IOException("no valid file");
            }
        }
        CSVRecord readingRecord = (CSVRecord)this.readingInput.getRecords().get(0);
        for (int i = 0; i < Math.min(this.NUMSENSORS, readingRecord.size() + 1); ++i) {
            this.timep.times[i].setText(readingRecord.get(i + 1));
        }
    }

    private CSVParser getParser(JFileChooser chooser) throws IOException {
        CSVParser parser = null;
        chooser.rescanCurrentDirectory();
        int retVal = chooser.showOpenDialog(this);
        if (retVal == 0) {
            FileReader reader = new FileReader(chooser.getSelectedFile());
            parser = new CSVParser((Reader)reader, CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setSkipHeaderRecord(true).build());
        }
        return parser;
    }

    private void doLoadMeasurementFromFile() throws IOException {
        if (this.measurementInput == null) {
            this.measurementInput = this.getParser(this.measurementFileChooser);
        }
        if (this.measurementInput.getRecords().isEmpty()) {
            this.measurementInput = this.getParser(this.measurementFileChooser);
            if (this.measurementInput.getRecords().isEmpty()) {
                throw new IOException("no valid file");
            }
        }
        CSVRecord measurementRecord = (CSVRecord)this.measurementInput.getRecords().get(0);
        Measurement m = new Measurement(null, Double.parseDouble(measurementRecord.get(1)), Double.parseDouble(measurementRecord.get(2)), Double.parseDouble(measurementRecord.get(3)), Engine.instance().getVSound(), 0, "Data File");
        Distributor.instance().submitMeasurement(m);
    }

    private Reading getReadingFromTimeFields() {
        double[] values = new double[this.NUMSENSORS + 1];
        for (int i = 0; i <= this.NUMSENSORS; ++i) {
            values[i] = 0.0;
            JTextField tmp = this.timep.times[i];
            if (tmp == null || tmp.getText().isEmpty()) continue;
            try {
                values[i] = IntlUtilities.doubleValue(tmp.getText());
                continue;
            }
            catch (ParseException ex) {
                log.error("Could not create number from {}, {}", (Object)tmp.getText(), (Object)ex.getMessage());
            }
        }
        return new Reading(this.id.getText(), values);
    }

    private void doReadingFromTimeFields() {
        Reading r = this.getReadingFromTimeFields();
        Distributor.instance().submitReading(r);
    }

    @Override
    public void notify(Reading r) {
        this.id.setText(r.getId());
        this.timep.notify(r);
    }

    private void doMeasurementFromPositionFields() {
        Reading r = new Reading(this.id.getText(), new double[]{0.0, 0.0, 0.0, 0.0});
        try {
            Measurement m = new Measurement(r, IntlUtilities.doubleValue(this.x.getText()), IntlUtilities.doubleValue(this.y.getText()), IntlUtilities.doubleValue(this.z.getText()), Engine.instance().getVSound(), 0, "Position Data");
            Distributor.instance().submitMeasurement(m);
        }
        catch (ParseException ex) {
            log.error("Could not translate a field to Number. {}", (Object)ex.getMessage());
        }
    }

    @Override
    public void notify(Measurement m) {
        this.x.setText(this.nf.format(m.getX()));
        this.y.setText(this.nf.format(m.getY()));
        this.z.setText(this.nf.format(m.getZ()));
        this.code.setText(m.textCode());
        this.timep.notify(m);
    }
}

