/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps.swing.debugger;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.vecmath.Point3d;
import jmri.jmrix.rps.Distributor;
import jmri.jmrix.rps.Engine;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.MeasurementListener;
import jmri.jmrix.rps.Reading;
import jmri.jmrix.rps.ReadingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerTimePane
extends JPanel
implements ReadingListener,
MeasurementListener {
    private NumberFormat nf;
    int NUMSENSORS = Engine.instance().getMaxReceiverNumber();
    protected JTextField[] times = new JTextField[this.NUMSENSORS + 1];
    private final JLabel[] residuals = new JLabel[this.NUMSENSORS + 1];
    private static final Logger log = LoggerFactory.getLogger(DebuggerTimePane.class);

    public DebuggerTimePane() {
        this.times[0] = null;
        this.residuals[0] = null;
        for (int i = 1; i <= this.NUMSENSORS; ++i) {
            this.times[i] = new JTextField(10);
            this.times[i].setText("");
            this.residuals[i] = new JLabel("          ");
        }
    }

    public void dispose() {
        Distributor.instance().removeReadingListener(this);
        Distributor.instance().removeMeasurementListener(this);
    }

    public void initComponents() {
        this.nf = NumberFormat.getInstance();
        this.nf.setMinimumFractionDigits(1);
        this.nf.setMaximumFractionDigits(1);
        this.nf.setGroupingUsed(false);
        this.setLayout(new BoxLayout(this, 1));
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(this.NUMSENSORS, 2));
        for (int i = 1; i <= this.NUMSENSORS; ++i) {
            JPanel p1 = new JPanel();
            p1.setLayout(new FlowLayout());
            p1.add(new JLabel("r" + i + ":"));
            p1.add(this.times[i]);
            p3.add(p1);
            p1 = new JPanel();
            p1.add(new JLabel("r-t: "));
            p1.add(this.residuals[i]);
            p3.add(p1);
        }
        this.add(p3);
    }

    void setResidual(int i, Measurement m) {
        if (this.times[i].getText().isEmpty()) {
            this.residuals[i].setText("");
            return;
        }
        try {
            if (Engine.instance().getReceiver(i) == null) {
                this.residuals[i].setText("");
                return;
            }
            Point3d p = Engine.instance().getReceiverPosition(i);
            Point3d x = new Point3d((double)((float)m.getX()), (double)((float)m.getY()), (double)((float)m.getZ()));
            double rt = p.distance(x) / Engine.instance().getVSound();
            int res = (int)(rt - m.getReading().getValue(i)) - Engine.instance().getOffset();
            this.residuals[i].setText("" + res);
            log.debug(" residual {} from {} vs {}", new Object[]{res, p, x});
        }
        catch (Exception e) {
            this.residuals[i].setText("");
        }
    }

    @Override
    public void notify(Reading r) {
        for (int i = 1; i <= Math.min(r.getNValues(), this.times.length - 1); ++i) {
            this.times[i].setText(this.nf.format(r.getValue(i)));
        }
    }

    @Override
    public void notify(Measurement m) {
        try {
            for (int i = 1; i <= this.NUMSENSORS; ++i) {
                this.setResidual(i, m);
            }
        }
        catch (Exception e) {
            log.error("Error setting residual: ", (Throwable)e);
        }
    }
}

