/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps.swing.polling;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.table.TableRowSorter;
import jmri.ModifiedFlag;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.jmrix.rps.Engine;
import jmri.jmrix.rps.PollingFile;
import jmri.jmrix.rps.swing.polling.Bundle;
import jmri.jmrix.rps.swing.polling.PollDataModel;
import jmri.swing.RowSorterUtil;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollTablePane
extends JPanel {
    PollDataModel pollModel = null;
    ModifiedFlag modifiedFlag;
    JTextField delay;
    JCheckBox polling;
    JRadioButton bscMode;
    JRadioButton directMode;
    JRadioButton throttleMode;
    private static final Logger log = LoggerFactory.getLogger(PollTablePane.class);

    public PollTablePane(ModifiedFlag flag) {
        this.modifiedFlag = flag;
        this.setLayout(new BoxLayout(this, 1));
        this.pollModel = new PollDataModel(this.modifiedFlag);
        JTable pollTable = new JTable(this.pollModel);
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        pollTable.setDefaultRenderer(JButton.class, buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        pollTable.setDefaultEditor(JButton.class, buttonEditor);
        pollTable.setDefaultRenderer(JComboBox.class, new ValueRenderer());
        pollTable.setDefaultEditor(JComboBox.class, new ValueEditor());
        TableRowSorter<PollDataModel> sorter = new TableRowSorter<PollDataModel>(this.pollModel);
        RowSorterUtil.setSortOrder(sorter, 2, SortOrder.ASCENDING);
        pollTable.setRowSorter(sorter);
        pollTable.setRowSelectionAllowed(false);
        pollTable.setPreferredScrollableViewportSize(new Dimension(580, 80));
        JScrollPane scrollPane = new JScrollPane(pollTable);
        this.add(scrollPane);
        JPanel p = new JPanel(){

            @Override
            public Dimension getMaximumSize() {
                int height = this.getPreferredSize().height;
                int width = super.getMaximumSize().width;
                return new Dimension(width, height);
            }
        };
        p.setLayout(new FlowLayout());
        this.polling = new JCheckBox(Bundle.getMessage("LabelPoll"));
        this.polling.setSelected(Engine.instance().getPolling());
        this.polling.setToolTipText(Bundle.getMessage("PollToolTip"));
        p.add(this.polling);
        this.polling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PollTablePane.this.modifiedFlag.setModifiedFlag(true);
                PollTablePane.this.checkPolling();
            }
        });
        JPanel m = new JPanel();
        m.setLayout(new BoxLayout(m, 1));
        ButtonGroup g = new ButtonGroup();
        this.bscMode = new JRadioButton(Bundle.getMessage("LabelBscMode"));
        this.bscMode.setSelected(Engine.instance().getBscPollMode());
        m.add(this.bscMode);
        g.add(this.bscMode);
        this.bscMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PollTablePane.this.modifiedFlag.setModifiedFlag(true);
                PollTablePane.this.checkMode();
            }
        });
        this.directMode = new JRadioButton(Bundle.getMessage("LabelDirectMode"));
        this.directMode.setSelected(Engine.instance().getDirectPollMode());
        m.add(this.directMode);
        g.add(this.directMode);
        this.directMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PollTablePane.this.modifiedFlag.setModifiedFlag(true);
                PollTablePane.this.checkMode();
            }
        });
        this.throttleMode = new JRadioButton(Bundle.getMessage("LabelThrottleMode"));
        this.throttleMode.setSelected(Engine.instance().getThrottlePollMode());
        m.add(this.throttleMode);
        g.add(this.throttleMode);
        this.throttleMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PollTablePane.this.modifiedFlag.setModifiedFlag(true);
                PollTablePane.this.checkMode();
            }
        });
        p.add(m);
        p.add(Box.createHorizontalGlue());
        p.add(new JLabel(Bundle.getMessage("LabelDelay")));
        this.delay = new JTextField(5);
        this.delay.setText("" + Engine.instance().getPollingInterval());
        this.delay.setToolTipText(Bundle.getMessage("IntervalToolTip"));
        p.add(this.delay);
        this.delay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PollTablePane.this.modifiedFlag.setModifiedFlag(true);
                PollTablePane.this.updateInterval();
            }
        });
        JButton b = new JButton(Bundle.getMessage("LabelSetDefault"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PollTablePane.this.modifiedFlag.setModifiedFlag(true);
                PollTablePane.this.setDefaults();
            }
        });
        p.add(b);
        this.add(p);
    }

    void setDefaults() {
        try {
            File file = new File(PollingFile.defaultFilename());
            log.info("located file {} for store", (Object)file);
            Engine.instance().storePollConfig(file);
            this.modifiedFlag.setModifiedFlag(false);
        }
        catch (Exception e) {
            log.error("exception during storeDefault: ", (Throwable)e);
        }
    }

    void checkPolling() {
        Engine.instance().setPolling(this.polling.isSelected());
    }

    void checkMode() {
        if (this.bscMode.isSelected()) {
            Engine.instance().setBscPollMode();
        } else if (this.throttleMode.isSelected()) {
            Engine.instance().setThrottlePollMode();
        } else {
            Engine.instance().setDirectPollMode();
        }
    }

    void updateInterval() {
        int interval = Integer.parseInt(this.delay.getText());
        log.debug("set interval to {}", (Object)interval);
        Engine.instance().setPollingInterval(interval);
    }

    public void dispose() {
        this.pollModel.dispose();
    }
}

