/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps.swing.soundset;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jmri.jmrix.rps.Distributor;
import jmri.jmrix.rps.Engine;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.MeasurementListener;
import jmri.jmrix.rps.Reading;
import jmri.jmrix.rps.ReadingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundSetPane
extends JPanel
implements ReadingListener,
MeasurementListener,
PropertyChangeListener {
    JTextField vsound;
    JTextField newval;
    JTextField dist;
    JTextField id;
    JTextField rcvr;
    JTextField speed;
    JCheckBox auto;
    JTextField gain;
    NumberFormat nf;
    private static final Logger log = LoggerFactory.getLogger(SoundSetPane.class);

    public void dispose() {
        Distributor.instance().removeReadingListener(this);
        Distributor.instance().removeMeasurementListener(this);
        Engine.instance().removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("vSound")) {
            this.vsound.setText(this.nf.format(e.getNewValue()));
        }
    }

    public void initComponents() {
        this.nf = NumberFormat.getInstance();
        this.nf.setMinimumFractionDigits(1);
        this.nf.setMaximumFractionDigits(5);
        this.nf.setGroupingUsed(false);
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel("Current sound velocity: "));
        this.vsound = new JTextField(5);
        this.vsound.setEnabled(false);
        this.vsound.setText(this.nf.format(Engine.instance().getVSound()));
        p.add(this.vsound);
        this.add(p);
        this.add(new JSeparator());
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel("New sound velocity: "));
        this.newval = new JTextField(8);
        p.add(this.newval);
        JButton b = new JButton("Set");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundSetPane.this.setPushed();
            }
        });
        p.add(b);
        this.add(p);
        this.add(new JSeparator());
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel("Known Distance: "));
        this.dist = new JTextField(5);
        p.add(this.dist);
        p.add(new JLabel("Transmitter ID: "));
        this.id = new JTextField(5);
        p.add(this.id);
        p.add(new JLabel("Receiver Number: "));
        this.rcvr = new JTextField(3);
        p.add(this.rcvr);
        this.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel("Measured Speed: "));
        this.speed = new JTextField(8);
        this.speed.setEnabled(false);
        p.add(this.speed);
        this.auto = new JCheckBox("Auto Set");
        p.add(this.auto);
        p.add(new JLabel("Damping: "));
        this.gain = new JTextField(3);
        this.gain.setText("10.");
        p.add(this.gain);
        this.add(p);
        Distributor.instance().addReadingListener(this);
        Distributor.instance().addMeasurementListener(this);
        Engine.instance().addPropertyChangeListener(this);
    }

    void setPushed() {
        double val = Double.parseDouble(this.newval.getText());
        Engine.instance().setVSound(val);
    }

    @Override
    public void notify(Reading r) {
        try {
            if (!r.getId().equals(this.id.getText())) {
                return;
            }
            int i = Integer.parseInt(this.rcvr.getText());
            if (i < 1 || i > r.getNValues()) {
                log.warn("resetting receiver number");
                this.rcvr.setText("");
            }
            log.debug("Rcvr {} saw {}", (Object)i, (Object)r.getValue(i));
            double val = r.getValue(i);
            if (val < 100.0) {
                log.warn("time too small to use: {}", (Object)val);
                return;
            }
            double newspeed = Double.parseDouble(this.dist.getText()) / val;
            this.speed.setText(this.nf.format(newspeed));
            if (this.auto.isSelected()) {
                double g = Double.parseDouble(this.gain.getText());
                if (g < 1.0) {
                    log.warn("resetting gain from {}", (Object)this.gain.getText());
                    this.gain.setText("10.");
                    return;
                }
                double updatedspeed = (newspeed + g * Engine.instance().getVSound()) / (g + 1.0);
                Engine.instance().setVSound(updatedspeed);
            }
        }
        catch (Exception e) {
            log.debug("Error calculating speed: {}", (Throwable)e);
            this.speed.setText("");
        }
    }

    @Override
    public void notify(Measurement m) {
    }
}

