/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps.trackingpanel;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jmri.jmrix.rps.RpsSystemConnectionMemo;
import jmri.jmrix.rps.trackingpanel.RpsTrackingControlPane;
import jmri.jmrix.rps.trackingpanel.RpsTrackingPanel;
import jmri.util.JmriJFrame;

public class RpsTrackingFrame
extends JmriJFrame {
    RpsSystemConnectionMemo memo = null;
    JButton clearButton;
    JCheckBox showErrButton;
    JCheckBox showRecButton;
    JCheckBox showRegButton;
    RpsTrackingPanel panel;
    public RpsTrackingControlPane scale;

    public RpsTrackingFrame(String s, RpsSystemConnectionMemo _memo) {
        super(s);
        this.memo = _memo;
    }

    public RpsTrackingFrame(RpsSystemConnectionMemo _memo) {
        this("RPS Tracking Display", _memo);
    }

    @Override
    public void dispose() {
        this.panel.dispose();
        super.dispose();
    }

    @Override
    public void initComponents() {
        this.addHelpMenu("package.jmri.jmrix.rps.trackingpanel.RpsTrackingFrame", true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.panel = new RpsTrackingPanel(this.memo);
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        JPanel line = new JPanel();
        line.setLayout(new FlowLayout());
        this.clearButton = new JButton("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RpsTrackingFrame.this.clearButtonChanged();
            }
        });
        line.add(this.clearButton);
        this.showErrButton = new JCheckBox("Show error points");
        this.showErrButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RpsTrackingFrame.this.showErrButtonChanged();
            }
        });
        line.add(this.showErrButton);
        this.showRecButton = new JCheckBox("Show receivers");
        this.showRecButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RpsTrackingFrame.this.showRecButtonChanged();
            }
        });
        this.showRecButton.setSelected(true);
        this.showRecButtonChanged();
        line.add(this.showRecButton);
        this.showRegButton = new JCheckBox("Show regions");
        this.showRegButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RpsTrackingFrame.this.showRegButtonChanged();
            }
        });
        this.showRegButton.setSelected(true);
        this.showRegButtonChanged();
        line.add(this.showRegButton);
        controls.add(line);
        this.scale = new RpsTrackingControlPane(this.panel);
        controls.add(this.scale);
        controls.add(new JSeparator());
        this.panel.setSize(440, 240);
        this.panel.setPreferredSize(new Dimension(440, 240));
        this.scale.set(-10.0, -10.0, 50.0, 50.0);
        this.scale.update();
        this.getContentPane().add(this.panel);
        this.getContentPane().add(new JSeparator());
        this.getContentPane().add(controls);
        this.panel.repaint();
        this.pack();
        Dimension d = controls.getSize();
        controls.setMinimumSize(d);
        controls.setPreferredSize(d);
        controls.setMaximumSize(d);
    }

    void showErrButtonChanged() {
        this.panel.setShowErrors(this.showErrButton.isSelected());
    }

    void showRecButtonChanged() {
        this.panel.setShowReceivers(this.showRecButton.isSelected());
        this.panel.repaint();
    }

    void showRegButtonChanged() {
        this.panel.setShowRegions(this.showRegButton.isSelected());
        this.panel.repaint();
    }

    void clearButtonChanged() {
        this.panel.clear();
    }
}

