/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.secsi;

import java.util.Comparator;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.secsi.SerialLightManager;
import jmri.jmrix.secsi.SerialSensorManager;
import jmri.jmrix.secsi.SerialTrafficController;
import jmri.jmrix.secsi.SerialTurnoutManager;
import jmri.jmrix.secsi.swing.SecsiComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecsiSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    private SerialTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(SecsiSystemConnectionMemo.class);

    public SecsiSystemConnectionMemo(@Nonnull String prefix, @Nonnull String name) {
        super(prefix, name);
        InstanceManager.store(this, SecsiSystemConnectionMemo.class);
        InstanceManager.store(new SecsiComponentFactory(this), ComponentFactory.class);
        log.debug("Created SecsiSystemConnectionMemo with prefix {}", (Object)prefix);
    }

    public SecsiSystemConnectionMemo() {
        this("V", "SECSI");
        log.debug("Created nameless SecsiSystemConnectionMemo");
    }

    public void setTrafficController(SerialTrafficController s) {
        this.tc = s;
    }

    public SerialTrafficController getTrafficController() {
        if (this.tc == null) {
            this.setTrafficController(new SerialTrafficController(this));
            log.debug("Auto create of SerialTrafficController for initial configuration");
        }
        return this.tc;
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return null;
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void configureManagers() {
        this.setTurnoutManager(new SerialTurnoutManager(this));
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        this.setLightManager(new SerialLightManager(this));
        InstanceManager.setLightManager(this.getLightManager());
        this.setSensorManager(new SerialSensorManager(this));
        InstanceManager.setSensorManager(this.getSensorManager());
        this.register();
    }

    public SensorManager getSensorManager() {
        return this.get(SensorManager.class);
    }

    public void setSensorManager(SerialSensorManager s) {
        this.store(s, SensorManager.class);
        this.getTrafficController().setSensorManager(s);
    }

    public TurnoutManager getTurnoutManager() {
        return this.get(TurnoutManager.class);
    }

    public void setTurnoutManager(SerialTurnoutManager t) {
        this.store(t, TurnoutManager.class);
    }

    public LightManager getLightManager() {
        return this.get(LightManager.class);
    }

    public void setLightManager(SerialLightManager l) {
        this.store(l, LightManager.class);
    }
}

