/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.secsi;

import jmri.implementation.AbstractLight;
import jmri.jmrix.secsi.SecsiSystemConnectionMemo;
import jmri.jmrix.secsi.SerialAddress;
import jmri.jmrix.secsi.SerialNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialLight
extends AbstractLight {
    private SecsiSystemConnectionMemo memo = null;
    int mBit = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialLight.class);

    public SerialLight(String systemName, SecsiSystemConnectionMemo _memo) {
        super(systemName);
        this.memo = _memo;
        this.initializeLight(systemName);
    }

    public SerialLight(String systemName, String userName, SecsiSystemConnectionMemo _memo) {
        super(systemName, userName);
        this.memo = _memo;
        this.initializeLight(systemName);
    }

    private void initializeLight(String systemName) {
        this.mBit = SerialAddress.getBitFromSystemName(systemName, this.memo.getSystemPrefix());
        this.setState(4);
    }

    @Override
    protected void doNewState(int oldState, int newState) {
        SerialNode mNode = SerialAddress.getNodeFromSystemName(this.getSystemName(), this.memo.getTrafficController());
        if (mNode != null) {
            if (newState == 2) {
                mNode.setOutputBit(this.mBit, false);
            } else if (newState == 4) {
                mNode.setOutputBit(this.mBit, true);
            } else {
                log.warn("illegal state requested for Light: {}", (Object)this.getSystemName());
            }
        }
    }
}

