/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.secsi;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.Sensor;
import jmri.jmrix.secsi.Bundle;
import jmri.jmrix.secsi.SecsiSystemConnectionMemo;
import jmri.jmrix.secsi.SerialAddress;
import jmri.jmrix.secsi.SerialListener;
import jmri.jmrix.secsi.SerialMessage;
import jmri.jmrix.secsi.SerialNode;
import jmri.jmrix.secsi.SerialReply;
import jmri.jmrix.secsi.SerialSensor;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialSensorManager
extends AbstractSensorManager
implements SerialListener {
    static final int SENSORSPERNODE = 1000;
    private static final Logger log = LoggerFactory.getLogger(SerialSensorManager.class);

    public SerialSensorManager(SecsiSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public SecsiSystemConnectionMemo getMemo() {
        return (SecsiSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String sName = SerialAddress.normalizeSystemName(systemName, this.getSystemPrefix());
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("Invalid Secsi Sensor system name - " + systemName);
        }
        Sensor s = this.getBySystemName(sName);
        if (s != null) {
            throw new IllegalArgumentException("Secsi Sensor with this name already exists - " + systemName);
        }
        String altName = SerialAddress.convertSystemNameToAlternate(sName, this.getSystemPrefix());
        s = this.getBySystemName(altName);
        if (s != null) {
            throw new IllegalArgumentException("Secsi Sensor with name  " + systemName + " already exists as " + altName);
        }
        int bit = SerialAddress.getBitFromSystemName(sName, this.getSystemPrefix());
        if (bit <= 0 || bit >= 1000) {
            throw new IllegalArgumentException("Sensor bit number " + Integer.toString(bit) + " is outside the supported range 1-" + Integer.toString(999));
        }
        s = userName == null ? new SerialSensor(sName, this.getMemo()) : new SerialSensor(sName, userName, this.getMemo());
        SerialNode node = SerialAddress.getNodeFromSystemName(sName, this.getMemo().getTrafficController());
        if (node == null) {
            log.warn("Sensor '{}' refers to an undefined Serial Node.", (Object)sName);
            return s;
        }
        node.registerSensor(s, bit - 1);
        return s;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return SerialAddress.validateSystemNameFormat(systemName, this.getSystemNamePrefix(), locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return SerialAddress.validSystemNameFormat(systemName, this.typeLetter(), this.getSystemPrefix());
    }

    @Override
    public void message(SerialMessage r) {
        log.warn("unexpected message");
    }

    @Override
    public void reply(SerialReply r) {
        log.debug("received node poll reply '{}'", (Object)r.toString());
        SerialNode node = (SerialNode)this.getMemo().getTrafficController().getNodeFromAddress(r.getAddr());
        if (node != null) {
            node.markChanges(r);
        }
    }

    public void registerSensorsForNode(SerialNode node) {
        log.debug("registering node {}", (Object)node.getNodeAddress());
        this.getNamedBeanSet().forEach(sensorInSet -> {
            SerialNode tNode;
            String sName = sensorInSet.getSystemName();
            log.debug("system name is {}", (Object)sName);
            if (sName.startsWith(this.getSystemNamePrefix()) && (tNode = SerialAddress.getNodeFromSystemName(sName, this.getMemo().getTrafficController())) == node) {
                log.debug("register sensor on node {}", (Object)node.getNodeAddress());
                node.registerSensor((Sensor)sensorInSet, SerialAddress.getBitFromSystemName(sName, this.getSystemPrefix()) - 1);
            }
        });
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }
}

