/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.secsi;

import jmri.implementation.AbstractTurnout;
import jmri.jmrix.secsi.SecsiSystemConnectionMemo;
import jmri.jmrix.secsi.SerialAddress;
import jmri.jmrix.secsi.SerialNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTurnout
extends AbstractTurnout {
    private SecsiSystemConnectionMemo memo = null;
    String tSystemName;
    int tBit;
    private static final Logger log = LoggerFactory.getLogger(SerialTurnout.class);

    public SerialTurnout(String systemName, String userName, SecsiSystemConnectionMemo _memo) {
        super(systemName, userName);
        this.memo = _memo;
        this.tSystemName = systemName;
        this.tBit = SerialAddress.getBitFromSystemName(systemName, this.memo.getSystemPrefix());
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both CLOSED and THROWN {}", (Object)newState);
                return;
            }
            this.sendMessage(this.getInverted());
        } else {
            this.sendMessage(!this.getInverted());
        }
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        log.debug("Send command to {} Pushbutton", (Object)(_pushButtonLockout ? "Lock" : "Unlock"));
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    protected void sendMessage(boolean closed) {
        SerialNode tNode = SerialAddress.getNodeFromSystemName(this.tSystemName, this.memo.getTrafficController());
        if (tNode == null) {
            return;
        }
        tNode.setOutputBit(this.tBit, closed);
    }
}

