/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.secsi.serialmon;

import jmri.jmrix.AbstractMonFrame;
import jmri.jmrix.secsi.SecsiSystemConnectionMemo;
import jmri.jmrix.secsi.SerialListener;
import jmri.jmrix.secsi.SerialMessage;
import jmri.jmrix.secsi.SerialReply;
import jmri.jmrix.secsi.serialmon.Bundle;

public class SerialMonFrame
extends AbstractMonFrame
implements SerialListener {
    private SecsiSystemConnectionMemo memo = null;

    public SerialMonFrame(SecsiSystemConnectionMemo _memo) {
        this.memo = _memo;
    }

    @Override
    protected String title() {
        return Bundle.getMessage("MonitorXTitle", "SECSI");
    }

    @Override
    protected void init() {
        this.memo.getTrafficController().addSerialListener(this);
    }

    @Override
    protected void setHelp() {
        this.addHelpMenu("package.jmri.jmrix.secsi.serialmon.SerialMonFrame", true);
    }

    @Override
    public void dispose() {
        this.memo.getTrafficController().removeSerialListener(this);
        super.dispose();
    }

    @Override
    public synchronized void message(SerialMessage l) {
        if (l.getNumDataElements() < 5) {
            this.nextLine("Truncated message of length " + l.getNumDataElements() + "\n", l.toString());
        } else if (l.isPoll()) {
            this.nextLine("Poll addr=" + l.getAddr() + "\n", l.toString());
        } else if (l.isXmt()) {
            String s = "Transmit addr=" + l.getAddr() + " byte " + (l.getElement(2) & 0xFF) + " data = " + Integer.toHexString(l.getElement(3) & 0xFF);
            this.nextLine(s + "\n", l.toString());
        } else {
            this.nextLine("Unrecognized cmd: \"" + l.toString() + "\"\n", l.toString());
        }
    }

    @Override
    public synchronized void reply(SerialReply l) {
        if (l.getNumDataElements() == 1) {
            if (l.getElement(0) == 0) {
                this.nextLine("NACK\n", l.toString());
            } else {
                this.nextLine("Ack from node " + l.getElement(0) + "\n", l.toString());
            }
        } else if (l.getNumDataElements() != 5) {
            this.nextLine("Truncated reply of length " + l.getNumDataElements() + ":" + l.toString() + "\n", l.toString());
        } else {
            StringBuilder s = new StringBuilder(String.format("Receive addr=%d IB=", l.getAddr()));
            for (int i = 2; i < 4; ++i) {
                s.append(Integer.toHexString(l.getElement(i))).append(" ");
            }
            this.nextLine(s.append("\n").toString(), l.toString());
        }
    }
}

