/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jmri.jmrix.AbstractStreamPortController;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.SprogInterface;
import jmri.jmrix.sprog.SprogListener;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.SprogTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogCSStreamPortController
extends AbstractStreamPortController
implements SprogInterface {
    private Thread rcvNotice = null;
    private SprogConstants.SprogMode operatingMode = SprogConstants.SprogMode.OPS;
    private static final Logger log = LoggerFactory.getLogger(SprogCSStreamPortController.class);

    public SprogCSStreamPortController(DataInputStream in, DataOutputStream out, String pname) {
        super(new SprogSystemConnectionMemo(SprogConstants.SprogMode.OPS), in, out, pname);
    }

    public SprogCSStreamPortController() {
        super(new SprogSystemConnectionMemo(SprogConstants.SprogMode.OPS));
    }

    @Override
    public void configure() {
        log.debug("configure() called.");
        SprogTrafficController control = new SprogTrafficController(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().setSprogMode(this.operatingMode);
        this.getSystemConnectionMemo().setSprogTrafficController(control);
        control.setAdapterMemo(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().configureCommandStation();
        this.getSystemConnectionMemo().configureManagers();
        control.connectPort(this);
        this.rcvNotice = new Thread(new RcvCheck(this.input, control));
        this.rcvNotice.setName("SPROG Stream Port Controller Receive thread");
        this.rcvNotice.start();
    }

    @Override
    public boolean status() {
        return true;
    }

    public boolean okToSend() {
        return true;
    }

    @Override
    public void addSprogListener(SprogListener l) {
        this.getSystemConnectionMemo().getSprogTrafficController().addSprogListener(l);
    }

    @Override
    public void removeSprogListener(SprogListener l) {
        this.getSystemConnectionMemo().getSprogTrafficController().removeSprogListener(l);
    }

    @Override
    public void sendSprogMessage(SprogMessage m, SprogListener l) {
        this.getSystemConnectionMemo().getSprogTrafficController().sendSprogMessage(m, l);
    }

    @Override
    public SprogSystemConnectionMemo getSystemConnectionMemo() {
        return (SprogSystemConnectionMemo)super.getSystemConnectionMemo();
    }

    protected static class RcvCheck
    implements Runnable {
        private SprogTrafficController control;
        private DataInputStream in;

        public RcvCheck(DataInputStream in, SprogTrafficController control) {
            this.in = in;
            this.control = control;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (this.in.available() <= 0) {
                            continue;
                        }
                        this.control.handleOneIncomingReply();
                    }
                }
                catch (IOException ioe) {
                    log.error("Error reading data from stream");
                    continue;
                }
                break;
            }
        }
    }
}

