/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.sprog.SprogCommandStation;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogCSThrottle
extends AbstractThrottle {
    private final SprogCommandStation commandStation;
    DccLocoAddress address;
    private static final Logger log = LoggerFactory.getLogger(SprogCSThrottle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SprogCSThrottle(SprogSystemConnectionMemo memo, LocoAddress address) {
        super(memo, SprogConstants.MAX_FUNCTIONS);
        if (address instanceof DccLocoAddress) {
            this.address = (DccLocoAddress)address;
        } else {
            log.error("{} is not a DccLocoAddress", (Object)address);
        }
        SprogCSThrottle sprogCSThrottle = this;
        synchronized (sprogCSThrottle) {
            this.speedSetting = 0.0f;
        }
        this.isForward = true;
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
        this.commandStation = memo != null && memo.get(CommandStation.class) != null ? (SprogCommandStation)memo.get(CommandStation.class) : (SprogCommandStation)InstanceManager.getNullableDefault(CommandStation.class);
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    protected void sendFunctionGroup1() {
        this.commandStation.function0Through4Packet(this.address, this.getFunction(0), this.getFunctionMomentary(0), this.getFunction(1), this.getFunctionMomentary(1), this.getFunction(2), this.getFunctionMomentary(2), this.getFunction(3), this.getFunctionMomentary(3), this.getFunction(4), this.getFunctionMomentary(4));
    }

    @Override
    protected void sendFunctionGroup2() {
        this.commandStation.function5Through8Packet(this.address, this.getFunction(5), this.getFunctionMomentary(5), this.getFunction(6), this.getFunctionMomentary(6), this.getFunction(7), this.getFunctionMomentary(7), this.getFunction(8), this.getFunctionMomentary(8));
    }

    @Override
    protected void sendFunctionGroup3() {
        this.commandStation.function9Through12Packet(this.address, this.getFunction(9), this.getFunctionMomentary(9), this.getFunction(10), this.getFunctionMomentary(10), this.getFunction(11), this.getFunctionMomentary(11), this.getFunction(12), this.getFunctionMomentary(12));
    }

    @Override
    protected void sendFunctionGroup4() {
        this.commandStation.function13Through20Packet(this.address, this.getFunction(13), this.getFunctionMomentary(13), this.getFunction(14), this.getFunctionMomentary(14), this.getFunction(15), this.getFunctionMomentary(15), this.getFunction(16), this.getFunctionMomentary(16), this.getFunction(17), this.getFunctionMomentary(17), this.getFunction(18), this.getFunctionMomentary(18), this.getFunction(19), this.getFunctionMomentary(19), this.getFunction(20), this.getFunctionMomentary(20));
    }

    @Override
    protected void sendFunctionGroup5() {
        this.commandStation.function21Through28Packet(this.address, this.getFunction(21), this.getFunctionMomentary(21), this.getFunction(22), this.getFunctionMomentary(22), this.getFunction(23), this.getFunctionMomentary(23), this.getFunction(24), this.getFunctionMomentary(24), this.getFunction(25), this.getFunctionMomentary(25), this.getFunction(26), this.getFunctionMomentary(26), this.getFunction(27), this.getFunctionMomentary(27), this.getFunction(28), this.getFunctionMomentary(28));
    }

    @Override
    protected void sendFunctionGroup6() {
        this.commandStation.function29Through36Packet(this.address, this.getFunctionNoWarn(29), this.getFunctionMomentaryNoWarn(29), this.getFunctionNoWarn(30), this.getFunctionMomentaryNoWarn(30), this.getFunctionNoWarn(31), this.getFunctionMomentaryNoWarn(32), this.getFunctionNoWarn(32), this.getFunctionMomentaryNoWarn(32), this.getFunctionNoWarn(33), this.getFunctionMomentaryNoWarn(33), this.getFunctionNoWarn(34), this.getFunctionMomentaryNoWarn(34), this.getFunctionNoWarn(35), this.getFunctionMomentaryNoWarn(35), this.getFunctionNoWarn(36), this.getFunctionMomentaryNoWarn(36));
    }

    @Override
    protected void sendFunctionGroup7() {
        this.commandStation.function37Through44Packet(this.address, this.getFunctionNoWarn(37), this.getFunctionMomentaryNoWarn(37), this.getFunctionNoWarn(38), this.getFunctionMomentaryNoWarn(38), this.getFunctionNoWarn(39), this.getFunctionMomentaryNoWarn(39), this.getFunctionNoWarn(40), this.getFunctionMomentaryNoWarn(40), this.getFunctionNoWarn(41), this.getFunctionMomentaryNoWarn(41), this.getFunctionNoWarn(42), this.getFunctionMomentaryNoWarn(42), this.getFunctionNoWarn(43), this.getFunctionMomentaryNoWarn(43), this.getFunctionNoWarn(44), this.getFunctionMomentaryNoWarn(44));
    }

    @Override
    protected void sendFunctionGroup8() {
        this.commandStation.function45Through52Packet(this.address, this.getFunctionNoWarn(45), this.getFunctionMomentaryNoWarn(45), this.getFunctionNoWarn(46), this.getFunctionMomentaryNoWarn(46), this.getFunctionNoWarn(47), this.getFunctionMomentaryNoWarn(47), this.getFunctionNoWarn(48), this.getFunctionMomentaryNoWarn(48), this.getFunctionNoWarn(49), this.getFunctionMomentaryNoWarn(49), this.getFunctionNoWarn(50), this.getFunctionMomentaryNoWarn(50), this.getFunctionNoWarn(51), this.getFunctionMomentaryNoWarn(51), this.getFunctionNoWarn(52), this.getFunctionMomentaryNoWarn(52));
    }

    @Override
    protected void sendFunctionGroup9() {
        this.commandStation.function53Through60Packet(this.address, this.getFunctionNoWarn(53), this.getFunctionMomentaryNoWarn(53), this.getFunctionNoWarn(54), this.getFunctionMomentaryNoWarn(54), this.getFunctionNoWarn(55), this.getFunctionMomentaryNoWarn(55), this.getFunctionNoWarn(56), this.getFunctionMomentaryNoWarn(56), this.getFunctionNoWarn(57), this.getFunctionMomentaryNoWarn(57), this.getFunctionNoWarn(58), this.getFunctionMomentaryNoWarn(58), this.getFunctionNoWarn(59), this.getFunctionMomentaryNoWarn(59), this.getFunctionNoWarn(60), this.getFunctionMomentaryNoWarn(60));
    }

    @Override
    protected void sendFunctionGroup10() {
        this.commandStation.function61Through68Packet(this.address, this.getFunctionNoWarn(61), this.getFunctionMomentaryNoWarn(61), this.getFunctionNoWarn(62), this.getFunctionMomentaryNoWarn(62), this.getFunctionNoWarn(63), this.getFunctionMomentaryNoWarn(63), this.getFunctionNoWarn(64), this.getFunctionMomentaryNoWarn(64), this.getFunctionNoWarn(65), this.getFunctionMomentaryNoWarn(65), this.getFunctionNoWarn(66), this.getFunctionMomentaryNoWarn(66), this.getFunctionNoWarn(67), this.getFunctionMomentaryNoWarn(67), this.getFunctionNoWarn(68), this.getFunctionMomentaryNoWarn(68));
    }

    @Override
    public synchronized void setSpeedSetting(float speed) {
        SpeedStepMode mode = this.getSpeedStepMode();
        if (mode == SpeedStepMode.NMRA_DCC_28) {
            float oldSpeed = this.speedSetting;
            this.speedSetting = speed;
            int value = Math.round(28.0f * speed);
            if (this.speedSetting > 0.0f && value == 0) {
                value = 1;
            }
            if (value > 0) {
                value += 3;
            }
            if (value > 31) {
                value = 31;
            }
            if (value < 0) {
                value = 1;
            }
            this.commandStation.setSpeed(SpeedStepMode.NMRA_DCC_28, this.address, value, this.isForward);
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        } else {
            float oldSpeed = this.speedSetting;
            this.speedSetting = speed;
            int value = Math.round(126.0f * speed);
            if (this.speedSetting > 0.0f && value == 0) {
                value = 1;
            }
            if (value > 0) {
                ++value;
            }
            if (value > 127) {
                value = 127;
            }
            if (value < 0) {
                value = 1;
            }
            this.commandStation.setSpeed(SpeedStepMode.NMRA_DCC_128, this.address, value, this.isForward);
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        }
        this.record(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        SprogCSThrottle sprogCSThrottle = this;
        synchronized (sprogCSThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    @Override
    public void throttleDispose() {
        this.active = false;
        this.commandStation.release(this.address);
        this.finishRecord();
    }
}

