/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import jmri.implementation.AbstractTurnout;
import jmri.jmrix.sprog.SprogCommandStation;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogCSTurnout
extends AbstractTurnout {
    private SprogSystemConnectionMemo _memo = null;
    private SprogCommandStation commandStation;
    int _number;
    private static final Logger log = LoggerFactory.getLogger(SprogCSTurnout.class);

    public SprogCSTurnout(int number, SprogSystemConnectionMemo memo) {
        super(memo.getSystemPrefix() + "T" + number);
        this._number = number;
        this._memo = memo;
        this.commandStation = this._memo.getCommandStation();
    }

    public int getNumber() {
        return this._number;
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if ((newState & 2) != 0) {
            if (this.statesOk(newState)) {
                this.commandStation.forwardCommandChangeToLayout(this._number, true ^ this.getInverted());
            }
        } else {
            this.commandStation.forwardCommandChangeToLayout(this._number, false ^ this.getInverted());
        }
    }

    public void setCommandStation(SprogCommandStation command) {
        this.commandStation = command;
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        if (log.isDebugEnabled()) {
            log.debug("Send command to {} Pushbutton {}T{}", new Object[]{_pushButtonLockout ? "Lock" : "Unlock", this._memo.getSystemPrefix(), this._number});
        }
    }

    @Override
    public boolean canInvert() {
        return true;
    }
}

