/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.Timer;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.sprog.SprogProgrammer;
import jmri.jmrix.sprog.SprogReply;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogOpsModeProgrammer
extends SprogProgrammer
implements AddressedProgrammer {
    int mAddress;
    boolean mLongAddr;
    private SprogSystemConnectionMemo _memo = null;
    private static final Logger log = LoggerFactory.getLogger(SprogOpsModeProgrammer.class);

    public SprogOpsModeProgrammer(int pAddress, boolean pLongAddr, SprogSystemConnectionMemo memo) {
        super(memo);
        this.mAddress = pAddress;
        this.mLongAddr = pLongAddr;
        this._memo = memo;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("write CV={} val={}", (Object)CV, (Object)val);
        this.useProgrammer(p);
        this.progState = 2;
        this._val = val;
        if (this._memo.getCommandStation().opsModepacket(this.mAddress, this.mLongAddr, CV, val) != null) {
            Timer t = new Timer(250, evt -> this.notifyProgListenerEnd(this._val, 0));
            t.setRepeats(false);
            t.start();
        } else {
            this.progState = 0;
            this.notifyProgListenerEnd(this._val, 128);
        }
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        log.error("readCV not available in this protocol");
        throw new ProgrammerException();
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        log.error("confirmCV not available in this protocol");
        throw new ProgrammerException();
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.OPSBYTEMODE);
        return ret;
    }

    @Override
    public synchronized void notifyReply(SprogReply m) {
    }

    @Override
    public boolean getCanRead() {
        return false;
    }

    @Override
    public boolean getLongAddress() {
        return this.mLongAddr;
    }

    @Override
    public int getAddressNumber() {
        return this.mAddress;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }

    void cleanup() {
    }
}

