/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import jmri.JmriException;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.sprog.SprogListener;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogReply;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.SprogTrafficController;
import jmri.managers.AbstractPowerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogPowerManager
extends AbstractPowerManager<SprogSystemConnectionMemo>
implements SprogListener {
    boolean waiting = false;
    int onReply = 1;
    SprogTrafficController trafficController = null;
    private static final Logger log = LoggerFactory.getLogger(SprogPowerManager.class);

    public SprogPowerManager(SprogSystemConnectionMemo memo) {
        super(memo);
        this.trafficController = memo.getSprogTrafficController();
        this.trafficController.addSprogListener(this);
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        this.checkTC();
        if (v == 2) {
            log.debug("setPower ON");
            this.waiting = true;
            this.onReply = 2;
            SprogMessage l = SprogMessage.getEnableMain();
            this.trafficController.sendSprogMessage(l, this);
        } else if (v == 4) {
            log.debug("setPower OFF");
            this.waiting = true;
            this.onReply = 4;
            SprogMessage l = SprogMessage.getKillMain();
            for (int i = 0; i < 3; ++i) {
                this.trafficController.sendSprogMessage(l, this);
            }
        }
        this.firePowerPropertyChange(old, this.power);
    }

    public void notePowerState(int v) {
        int old = this.power;
        this.power = v;
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void dispose() throws JmriException {
        this.trafficController.removeSprogListener(this);
        this.trafficController = null;
    }

    private void checkTC() throws JmriException {
        if (this.trafficController == null) {
            throw new JmriException("attempt to use SprogPowerManager after dispose");
        }
    }

    @Override
    public void notifyReply(SprogReply m) {
        if (this.waiting) {
            log.debug("Reply while waiting");
            int old = this.power;
            this.power = this.onReply;
            this.firePowerPropertyChange(old, this.power);
        }
        this.waiting = false;
    }

    @Override
    public void notifyMessage(SprogMessage m) {
        if (m.isKillMain()) {
            log.debug("Seen Kill Main");
            this.waiting = true;
            this.onReply = 4;
        } else if (m.isEnableMain()) {
            log.debug("Seen Enable Main");
            this.waiting = true;
            this.onReply = 2;
        }
    }

    public void notify(AbstractMessage m) {
        if (m instanceof SprogMessage) {
            this.notifyMessage((SprogMessage)m);
        } else if (m instanceof SprogReply) {
            this.notifyReply((SprogReply)m);
        }
    }
}

