/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import java.util.Arrays;
import jmri.DccLocoAddress;
import jmri.NmraPacket;
import jmri.SpeedStepMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogSlot {
    private boolean speedPacket = false;
    private SpeedStepMode speedMode = SpeedStepMode.NMRA_DCC_128;
    private byte[] payload = new byte[6];
    private int repeat;
    private int addr;
    private boolean isLong;
    private int spd;
    private boolean forward;
    private int status;
    private final int slot;
    private boolean opsPkt;
    private boolean f0to4Packet;
    private boolean f5to8Packet;
    private boolean f9to12Packet;
    private boolean f13to20Packet;
    private boolean f21to28Packet;
    private boolean f29to36Packet;
    private boolean f37to44Packet;
    private boolean f45to52Packet;
    private boolean f53to60Packet;
    private boolean f61to68Packet;
    private boolean repeatF0 = false;
    private boolean repeatF1 = false;
    private boolean repeatF2 = false;
    private boolean repeatF3 = false;
    private boolean repeatF4 = false;
    private boolean repeatF5 = false;
    private boolean repeatF6 = false;
    private boolean repeatF7 = false;
    private boolean repeatF8 = false;
    private boolean repeatF9 = false;
    private boolean repeatF10 = false;
    private boolean repeatF11 = false;
    private boolean repeatF12 = false;
    private boolean repeatF13 = false;
    private boolean repeatF14 = false;
    private boolean repeatF15 = false;
    private boolean repeatF16 = false;
    private boolean repeatF17 = false;
    private boolean repeatF18 = false;
    private boolean repeatF19 = false;
    private boolean repeatF20 = false;
    private boolean repeatF21 = false;
    private boolean repeatF22 = false;
    private boolean repeatF23 = false;
    private boolean repeatF24 = false;
    private boolean repeatF25 = false;
    private boolean repeatF26 = false;
    private boolean repeatF27 = false;
    private boolean repeatF28 = false;
    private boolean repeatF29 = false;
    private boolean repeatF30 = false;
    private boolean repeatF31 = false;
    private boolean repeatF32 = false;
    private boolean repeatF33 = false;
    private boolean repeatF34 = false;
    private boolean repeatF35 = false;
    private boolean repeatF36 = false;
    private boolean repeatF37 = false;
    private boolean repeatF38 = false;
    private boolean repeatF39 = false;
    private boolean repeatF40 = false;
    private boolean repeatF41 = false;
    private boolean repeatF42 = false;
    private boolean repeatF43 = false;
    private boolean repeatF44 = false;
    private boolean repeatF45 = false;
    private boolean repeatF46 = false;
    private boolean repeatF47 = false;
    private boolean repeatF48 = false;
    private boolean repeatF49 = false;
    private boolean repeatF50 = false;
    private boolean repeatF51 = false;
    private boolean repeatF52 = false;
    private boolean repeatF53 = false;
    private boolean repeatF54 = false;
    private boolean repeatF55 = false;
    private boolean repeatF56 = false;
    private boolean repeatF57 = false;
    private boolean repeatF58 = false;
    private boolean repeatF59 = false;
    private boolean repeatF60 = false;
    private boolean repeatF61 = false;
    private boolean repeatF62 = false;
    private boolean repeatF63 = false;
    private boolean repeatF64 = false;
    private boolean repeatF65 = false;
    private boolean repeatF66 = false;
    private boolean repeatF67 = false;
    private boolean repeatF68 = false;
    private long lastUpdateTime;
    private static final Logger log = LoggerFactory.getLogger(SprogSlot.class);

    public SprogSlot(int num) {
        this.payload[0] = 0;
        this.payload[1] = 0;
        this.payload[2] = 0;
        this.f0to4Packet = false;
        this.f5to8Packet = false;
        this.f9to12Packet = false;
        this.f13to20Packet = false;
        this.f21to28Packet = false;
        this.f29to36Packet = false;
        this.f37to44Packet = false;
        this.f45to52Packet = false;
        this.f53to60Packet = false;
        this.f61to68Packet = false;
        this.repeat = -1;
        this.addr = 0;
        this.isLong = false;
        this.spd = 0;
        this.forward = true;
        this.status = 0;
        this.slot = num;
        this.opsPkt = false;
    }

    public boolean isF0to4Packet() {
        return this.f0to4Packet;
    }

    public boolean isF5to8Packet() {
        return this.f5to8Packet;
    }

    public boolean isF9to12Packet() {
        return this.f9to12Packet;
    }

    public boolean isF13to20Packet() {
        return this.f13to20Packet;
    }

    public boolean isF21to28Packet() {
        return this.f21to28Packet;
    }

    public boolean isF29to36Packet() {
        return this.f29to36Packet;
    }

    public boolean isF37to44Packet() {
        return this.f37to44Packet;
    }

    public boolean isF45to52Packet() {
        return this.f45to52Packet;
    }

    public boolean isF53to60Packet() {
        return this.f53to60Packet;
    }

    public boolean isF61to68Packet() {
        return this.f61to68Packet;
    }

    public void set(int address, byte[] payload, int repeat) {
        this.addr = address;
        Arrays.copyOf(payload, payload.length);
        this.setRepeat(repeat);
        this.status = 1;
    }

    public void setAccessoryPacket(int address, boolean closed, int repeats) {
        this.payload = NmraPacket.accDecoderPkt(address, closed);
        this.addr = address + 10000;
        this.repeat = repeats;
        this.status = 1;
    }

    public boolean isSpeedPacket() {
        return this.speedPacket;
    }

    public void setSpeed(SpeedStepMode mode, int address, boolean isLongAddress, int speed, boolean forward) {
        this.addr = address;
        this.isLong = isLongAddress;
        this.spd = speed;
        this.speedPacket = true;
        this.speedMode = mode;
        this.f0to4Packet = false;
        this.f5to8Packet = false;
        this.f9to12Packet = false;
        this.f13to20Packet = false;
        this.f21to28Packet = false;
        this.f29to36Packet = false;
        this.f37to44Packet = false;
        this.f45to52Packet = false;
        this.f53to60Packet = false;
        this.f61to68Packet = false;
        this.forward = forward;
        this.payload = mode == SpeedStepMode.NMRA_DCC_28 ? NmraPacket.speedStep28Packet(true, this.addr, this.isLong, this.spd, forward) : NmraPacket.speedStep128Packet(this.addr, this.isLong, this.spd, forward);
        this.status = 1;
    }

    public void setOps(int address, boolean longAddr, int cv, int val) {
        this.payload = NmraPacket.opsCvWriteByte(address, longAddr, cv, val);
        this.repeat = 3;
        this.opsPkt = true;
        this.status = 1;
    }

    public void f5to8packet(int address, boolean isLongAddress, boolean f5, boolean f5Momentary, boolean f6, boolean f6Momentary, boolean f7, boolean f7Momentary, boolean f8, boolean f8Momentary) {
        this.f5to8Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF5 && !f5 || this.repeatF6 && !f6 || this.repeatF7 && !f7 || this.repeatF8 && !f8) {
            this.repeat = 3;
        }
        this.repeatF5 = !f5Momentary && f5;
        this.repeatF6 = !f6Momentary && f6;
        this.repeatF7 = !f7Momentary && f7;
        this.repeatF8 = !f8Momentary && f8;
        this.payload = NmraPacket.function5Through8Packet(address, isLongAddress, f5, f6, f7, f8);
        this.status = 1;
    }

    public void f9to12packet(int address, boolean isLongAddress, boolean f9, boolean f9Momentary, boolean f10, boolean f10Momentary, boolean f11, boolean f11Momentary, boolean f12, boolean f12Momentary) {
        this.f9to12Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF9 && !f9 || this.repeatF10 && !f10 || this.repeatF11 && !f11 || this.repeatF12 && !f12) {
            this.repeat = 3;
        }
        this.repeatF9 = !f9Momentary && f9;
        this.repeatF10 = !f10Momentary && f10;
        this.repeatF11 = !f11Momentary && f11;
        this.repeatF12 = !f12Momentary && f12;
        this.payload = NmraPacket.function9Through12Packet(address, isLongAddress, f9, f10, f11, f12);
        this.status = 1;
    }

    public void f13to20packet(int address, boolean isLongAddress, boolean f13, boolean f13Momentary, boolean f14, boolean f14Momentary, boolean f15, boolean f15Momentary, boolean f16, boolean f16Momentary, boolean f17, boolean f17Momentary, boolean f18, boolean f18Momentary, boolean f19, boolean f19Momentary, boolean f20, boolean f20Momentary) {
        this.f13to20Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF13 && !f13 || this.repeatF14 && !f14 || this.repeatF15 && !f15 || this.repeatF16 && !f16 || this.repeatF17 && !f17 || this.repeatF18 && !f18 || this.repeatF19 && !f19 || this.repeatF20 && !f20) {
            this.repeat = 3;
        }
        this.repeatF13 = !f13Momentary && f13;
        this.repeatF14 = !f14Momentary && f14;
        this.repeatF15 = !f15Momentary && f15;
        this.repeatF16 = !f16Momentary && f16;
        this.repeatF17 = !f17Momentary && f17;
        this.repeatF18 = !f18Momentary && f18;
        this.repeatF19 = !f19Momentary && f19;
        this.repeatF20 = !f20Momentary && f20;
        this.payload = NmraPacket.function13Through20Packet(address, isLongAddress, f13, f14, f15, f16, f17, f18, f19, f20);
        this.status = 1;
    }

    public void f21to28packet(int address, boolean isLongAddress, boolean f21, boolean f21Momentary, boolean f22, boolean f22Momentary, boolean f23, boolean f23Momentary, boolean f24, boolean f24Momentary, boolean f25, boolean f25Momentary, boolean f26, boolean f26Momentary, boolean f27, boolean f27Momentary, boolean f28, boolean f28Momentary) {
        this.f21to28Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF21 && !f21 || this.repeatF22 && !f22 || this.repeatF23 && !f23 || this.repeatF24 && !f24 || this.repeatF25 && !f25 || this.repeatF26 && !f26 || this.repeatF27 && !f27 || this.repeatF28 && !f28) {
            this.repeat = 3;
        }
        this.repeatF21 = !f21Momentary && f21;
        this.repeatF22 = !f22Momentary && f22;
        this.repeatF23 = !f23Momentary && f23;
        this.repeatF24 = !f24Momentary && f24;
        this.repeatF25 = !f25Momentary && f25;
        this.repeatF26 = !f26Momentary && f26;
        this.repeatF27 = !f27Momentary && f27;
        this.repeatF28 = !f28Momentary && f28;
        this.payload = NmraPacket.function21Through28Packet(address, isLongAddress, f21, f22, f23, f24, f25, f26, f27, f28);
        this.status = 1;
    }

    public void f29to36packet(int address, boolean isLongAddress, boolean f29, boolean f29Momentary, boolean f30, boolean f30Momentary, boolean f31, boolean f31Momentary, boolean f32, boolean f32Momentary, boolean f33, boolean f33Momentary, boolean f34, boolean f34Momentary, boolean f35, boolean f35Momentary, boolean f36, boolean f36Momentary) {
        this.f29to36Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF29 && !f29 || this.repeatF30 && !f30 || this.repeatF31 && !f31 || this.repeatF32 && !f32 || this.repeatF33 && !f33 || this.repeatF34 && !f34 || this.repeatF35 && !f35 || this.repeatF36 && !f36) {
            this.repeat = 3;
        }
        this.repeatF29 = !f29Momentary && f29;
        this.repeatF30 = !f30Momentary && f30;
        this.repeatF31 = !f31Momentary && f31;
        this.repeatF32 = !f32Momentary && f32;
        this.repeatF33 = !f33Momentary && f33;
        this.repeatF34 = !f34Momentary && f34;
        this.repeatF35 = !f35Momentary && f35;
        this.repeatF36 = !f36Momentary && f36;
        this.payload = NmraPacket.function29Through36Packet(address, isLongAddress, f29, f30, f31, f32, f33, f34, f35, f36);
        this.status = 1;
    }

    public void f37to44packet(int address, boolean isLongAddress, boolean f37, boolean f37Momentary, boolean f38, boolean f38Momentary, boolean f39, boolean f39Momentary, boolean f40, boolean f40Momentary, boolean f41, boolean f41Momentary, boolean f42, boolean f42Momentary, boolean f43, boolean f43Momentary, boolean f44, boolean f44Momentary) {
        this.f37to44Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF37 && !f37 || this.repeatF38 && !f38 || this.repeatF39 && !f39 || this.repeatF40 && !f40 || this.repeatF41 && !f41 || this.repeatF42 && !f42 || this.repeatF43 && !f43 || this.repeatF44 && !f44) {
            this.repeat = 3;
        }
        this.repeatF37 = !f37Momentary && f37;
        this.repeatF38 = !f38Momentary && f38;
        this.repeatF39 = !f39Momentary && f39;
        this.repeatF40 = !f40Momentary && f40;
        this.repeatF41 = !f41Momentary && f41;
        this.repeatF42 = !f42Momentary && f42;
        this.repeatF43 = !f43Momentary && f43;
        this.repeatF44 = !f44Momentary && f44;
        this.payload = NmraPacket.function37Through44Packet(address, isLongAddress, f37, f38, f39, f40, f41, f42, f43, f44);
        this.status = 1;
    }

    public void f45to52packet(int address, boolean isLongAddress, boolean f45, boolean f45Momentary, boolean f46, boolean f46Momentary, boolean f47, boolean f47Momentary, boolean f48, boolean f48Momentary, boolean f49, boolean f49Momentary, boolean f50, boolean f50Momentary, boolean f51, boolean f51Momentary, boolean f52, boolean f52Momentary) {
        this.f45to52Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF45 && !f45 || this.repeatF46 && !f46 || this.repeatF47 && !f47 || this.repeatF48 && !f48 || this.repeatF49 && !f49 || this.repeatF50 && !f50 || this.repeatF51 && !f51 || this.repeatF52 && !f52) {
            this.repeat = 3;
        }
        this.repeatF45 = !f45Momentary && f45;
        this.repeatF46 = !f46Momentary && f46;
        this.repeatF47 = !f47Momentary && f47;
        this.repeatF48 = !f48Momentary && f48;
        this.repeatF49 = !f49Momentary && f49;
        this.repeatF50 = !f50Momentary && f50;
        this.repeatF51 = !f51Momentary && f51;
        this.repeatF52 = !f52Momentary && f52;
        this.payload = NmraPacket.function45Through52Packet(address, isLongAddress, f45, f46, f47, f48, f49, f50, f51, f52);
        this.status = 1;
    }

    public void f53to60packet(int address, boolean isLongAddress, boolean f53, boolean f53Momentary, boolean f54, boolean f54Momentary, boolean f55, boolean f55Momentary, boolean f56, boolean f56Momentary, boolean f57, boolean f57Momentary, boolean f58, boolean f58Momentary, boolean f59, boolean f59Momentary, boolean f60, boolean f60Momentary) {
        this.f53to60Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF53 && !f53 || this.repeatF54 && !f54 || this.repeatF55 && !f55 || this.repeatF56 && !f56 || this.repeatF57 && !f57 || this.repeatF58 && !f59 || this.repeatF59 && !f59 || this.repeatF60 && !f60) {
            this.repeat = 3;
        }
        this.repeatF53 = !f53Momentary && f53;
        this.repeatF54 = !f54Momentary && f54;
        this.repeatF55 = !f55Momentary && f55;
        this.repeatF56 = !f56Momentary && f56;
        this.repeatF57 = !f57Momentary && f57;
        this.repeatF58 = !f58Momentary && f58;
        this.repeatF59 = !f59Momentary && f59;
        this.repeatF60 = !f60Momentary && f60;
        this.payload = NmraPacket.function53Through60Packet(address, isLongAddress, f53, f54, f55, f56, f57, f58, f59, f60);
        this.status = 1;
    }

    public void f61to68packet(int address, boolean isLongAddress, boolean f61, boolean f61Momentary, boolean f62, boolean f62Momentary, boolean f63, boolean f63Momentary, boolean f64, boolean f64Momentary, boolean f65, boolean f65Momentary, boolean f66, boolean f66Momentary, boolean f67, boolean f67Momentary, boolean f68, boolean f68Momentary) {
        this.f61to68Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF61 && !f61 || this.repeatF62 && !f62 || this.repeatF63 && !f63 || this.repeatF64 && !f64 || this.repeatF65 && !f65 || this.repeatF66 && !f66 || this.repeatF67 && !f67 || this.repeatF68 && !f68) {
            this.repeat = 3;
        }
        this.repeatF61 = !f61Momentary && f61;
        this.repeatF62 = !f62Momentary && f62;
        this.repeatF63 = !f63Momentary && f63;
        this.repeatF64 = !f64Momentary && f64;
        this.repeatF65 = !f65Momentary && f65;
        this.repeatF66 = !f66Momentary && f66;
        this.repeatF67 = !f67Momentary && f67;
        this.repeatF68 = !f68Momentary && f68;
        this.payload = NmraPacket.function61Through68Packet(address, isLongAddress, f61, f62, f63, f64, f65, f66, f67, f68);
        this.status = 1;
    }

    public void f0to4packet(int address, boolean isLongAddress, boolean f0, boolean f0Momentary, boolean f1, boolean f1Momentary, boolean f2, boolean f2Momentary, boolean f3, boolean f3Momentary, boolean f4, boolean f4Momentary) {
        this.f0to4Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF0 && !f0 || this.repeatF1 && !f1 || this.repeatF2 && !f2 || this.repeatF3 && !f3 || this.repeatF4 && !f4) {
            this.repeat = 3;
        }
        this.repeatF0 = !f0Momentary && f0;
        this.repeatF1 = !f1Momentary && f1;
        this.repeatF2 = !f2Momentary && f2;
        this.repeatF3 = !f3Momentary && f3;
        this.repeatF4 = !f4Momentary && f4;
        this.payload = NmraPacket.function0Through4Packet(address, isLongAddress, f0, f1, f2, f3, f4);
        this.status = 1;
    }

    public boolean isFinished() {
        if (this.isF0to4Packet() && (this.repeatF0 || this.repeatF1 || this.repeatF2 || this.repeatF3 || this.repeatF4)) {
            return false;
        }
        if (this.isF5to8Packet() && (this.repeatF5 || this.repeatF6 || this.repeatF7 || this.repeatF8)) {
            return false;
        }
        if (this.isF9to12Packet() && (this.repeatF9 || this.repeatF10 || this.repeatF11 || this.repeatF12)) {
            return false;
        }
        if (this.isF13to20Packet() && (this.repeatF13 || this.repeatF14 || this.repeatF15 || this.repeatF16 || this.repeatF17 || this.repeatF18 || this.repeatF19 || this.repeatF20)) {
            return false;
        }
        if (this.isF21to28Packet() && (this.repeatF21 || this.repeatF22 || this.repeatF23 || this.repeatF24 || this.repeatF25 || this.repeatF26 || this.repeatF27 || this.repeatF28)) {
            return false;
        }
        if (this.isSpeedPacket() && this.status == 1) {
            return false;
        }
        if (this.repeat > 0 && this.status == 1) {
            return false;
        }
        this.clear();
        return true;
    }

    public void eStop() {
        this.setSpeed(this.speedMode, this.addr, this.isLong, 1, this.forward);
    }

    public void clear() {
        this.status = 0;
        this.addr = 0;
        this.spd = 0;
        this.speedPacket = false;
        this.f0to4Packet = false;
        this.f5to8Packet = false;
        this.f9to12Packet = false;
        this.f13to20Packet = false;
        this.f21to28Packet = false;
        this.f29to36Packet = false;
        this.f37to44Packet = false;
        this.f45to52Packet = false;
        this.f53to60Packet = false;
        this.f61to68Packet = false;
        if (this.payload != null) {
            this.payload[0] = 0;
            this.payload[1] = 0;
            this.payload[2] = 0;
        }
        this.opsPkt = false;
    }

    public boolean isLongAddress() {
        return this.isLong;
    }

    public boolean isFree() {
        return this.status == 0;
    }

    public int slotStatus() {
        return this.status;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeat(int r) {
        this.repeat = r;
    }

    private int doRepeat() {
        if (this.repeat > 0) {
            log.debug("Slot {} repeats", (Object)this.slot);
            --this.repeat;
            if (this.repeat == 0) {
                log.debug("Clear slot {} due to repeats exhausted", (Object)this.slot);
                this.clear();
            }
        }
        return this.repeat;
    }

    public int speed() {
        return this.spd;
    }

    public int locoAddr() {
        return this.addr;
    }

    public int getAddr() {
        if (!this.opsPkt) {
            return this.addr;
        }
        return this.addressFromPacket();
    }

    public void setAddr(int a) {
        this.addr = a;
    }

    public boolean getIsLong() {
        if (!this.opsPkt) {
            return this.isLong;
        }
        return (this.payload[0] & 0xC0) >= 192;
    }

    public void setIsLong(boolean a) {
        this.isLong = a;
    }

    public boolean isForward() {
        return this.forward;
    }

    public boolean isOpsPkt() {
        return this.opsPkt;
    }

    public boolean isActiveAddressMatch(DccLocoAddress address) {
        return this.status == 1 && this.getAddr() == address.getNumber() && this.getIsLong() == address.isLongAddress();
    }

    public byte[] getPayload() {
        byte[] p = this.payload != null ? Arrays.copyOf(this.payload, this.getPayloadLength()) : new byte[]{};
        this.doRepeat();
        return p;
    }

    public int getSlotNumber() {
        return this.slot;
    }

    private int getPayloadLength() {
        return this.payload.length;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    private int addressFromPacket() {
        if (this.isFree()) {
            return -1;
        }
        if ((this.payload[0] & 0xC0) == 192) {
            return (this.payload[0] & 0x3F) << 8 | this.payload[1] & 0xFF;
        }
        return this.payload[0];
    }
}

