/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import java.util.Comparator;
import java.util.ResourceBundle;
import jmri.AddressedProgrammerManager;
import jmri.CommandStation;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.sprog.Bundle;
import jmri.jmrix.sprog.SprogCSThrottleManager;
import jmri.jmrix.sprog.SprogCommandStation;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.SprogPowerManager;
import jmri.jmrix.sprog.SprogProgrammer;
import jmri.jmrix.sprog.SprogProgrammerManager;
import jmri.jmrix.sprog.SprogThrottleManager;
import jmri.jmrix.sprog.SprogTrafficController;
import jmri.jmrix.sprog.SprogTurnoutManager;
import jmri.jmrix.sprog.swing.SprogComponentFactory;
import jmri.jmrix.sprog.update.SprogType;
import jmri.jmrix.sprog.update.SprogVersion;
import jmri.jmrix.sprog.update.SprogVersionQuery;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    private SprogConstants.SprogMode sprogMode;
    private SprogVersion sprogVersion;
    ComponentFactory cf = null;
    private SprogTrafficController st;
    private Thread slotThread;
    private int numSlots = 16;
    private SprogVersionQuery svq = null;
    private static final Logger log = LoggerFactory.getLogger(SprogSystemConnectionMemo.class);

    public SprogSystemConnectionMemo(SprogTrafficController st, SprogConstants.SprogMode sm) {
        super(st.getController().getSystemConnectionMemo().getSystemPrefix(), "SPROG DCC");
        if (log.isDebugEnabled()) {
            log.debug("SprogSystemConnectionMemo, prefix='{}'", (Object)st.getController().getSystemConnectionMemo().getSystemPrefix());
        }
        this.st = st;
        this.init(sm, new SprogType(0));
    }

    public SprogSystemConnectionMemo(SprogConstants.SprogMode sm) {
        this(sm, new SprogType(0));
    }

    public SprogSystemConnectionMemo(SprogConstants.SprogMode sm, SprogType type) {
        super("S", "SPROG DCC");
        this.init(sm, type);
    }

    private void init(SprogConstants.SprogMode sm, SprogType type) {
        this.sprogMode = sm;
        this.sprogVersion = new SprogVersion(type);
        this.cf = new SprogComponentFactory(this);
        InstanceManager.store(this, SprogSystemConnectionMemo.class);
        InstanceManager.store(this.cf, ComponentFactory.class);
    }

    public SprogSystemConnectionMemo() {
        this(SprogConstants.SprogMode.OPS);
    }

    public void setSprogMode(SprogConstants.SprogMode mode) {
        this.sprogMode = mode;
    }

    public SprogConstants.SprogMode getSprogMode() {
        return this.sprogMode;
    }

    public SprogVersion getSprogVersion() {
        return this.sprogVersion;
    }

    public void setSprogVersion(SprogVersion version) {
        this.sprogVersion = version;
    }

    public SprogType getSprogType() {
        return this.sprogVersion.sprogType;
    }

    public SprogTrafficController getSprogTrafficController() {
        return this.st;
    }

    public void setSprogTrafficController(SprogTrafficController st) {
        this.st = st;
    }

    public Thread getSlotThread() {
        return this.slotThread;
    }

    public int getNumSlots() {
        return this.numSlots;
    }

    public void configureCommandStation(boolean powerOption) {
        if (this.classObjectMap.containsKey(CommandStation.class)) {
            return;
        }
        log.debug("start command station queuing thread");
        SprogCommandStation commandStation = new SprogCommandStation(this.st);
        commandStation.setSystemConnectionMemo(this);
        commandStation.setPowerState(powerOption);
        InstanceManager.store(commandStation, CommandStation.class);
        this.store(commandStation, CommandStation.class);
        switch (this.sprogMode) {
            case OPS: {
                this.slotThread = ThreadingUtil.newThread(commandStation);
                this.slotThread.setName("SPROG slot thread");
                this.slotThread.setPriority(8);
                this.slotThread.start();
                break;
            }
            case SERVICE: {
                break;
            }
            default: {
                log.error("Unhandled sprogMode: {}", (Object)this.sprogMode);
            }
        }
    }

    public void configureCommandStation() {
        this.configureCommandStation(false);
    }

    public void configureCommandStation(int slots) {
        this.numSlots = slots;
        this.configureCommandStation(false);
    }

    public void configureCommandStation(int slots, String powerOption) {
        this.numSlots = slots;
        if (powerOption != null && powerOption.equals(Bundle.getMessage("PowerStateOn"))) {
            this.configureCommandStation(true);
        } else {
            this.configureCommandStation(false);
        }
    }

    public SprogCommandStation getCommandStation() {
        return (SprogCommandStation)this.get(CommandStation.class);
    }

    @Override
    public boolean provides(Class<?> type) {
        if (this.getDisabled()) {
            return false;
        }
        if (type.equals(CommandStation.class)) {
            if (this.sprogMode == null) {
                return false;
            }
            switch (this.sprogMode) {
                case OPS: {
                    return true;
                }
                case SERVICE: {
                    return false;
                }
            }
            log.error("Unhandled sprogMode: {}", (Object)this.sprogMode);
        }
        return super.provides(type);
    }

    @Override
    public void configureManagers() {
        this.configureCommandStation();
        if (this.getProgrammerManager().isAddressedModePossible()) {
            InstanceManager.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
            this.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
        }
        if (this.getProgrammerManager().isGlobalProgrammerAvailable()) {
            InstanceManager.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
            this.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
        }
        SprogPowerManager powerManager = new SprogPowerManager(this);
        InstanceManager.store(powerManager, PowerManager.class);
        this.store(powerManager, PowerManager.class);
        SprogTurnoutManager sprogTurnoutManager = new SprogTurnoutManager(this);
        InstanceManager.setTurnoutManager(sprogTurnoutManager);
        this.store(sprogTurnoutManager, TurnoutManager.class);
        switch (this.sprogMode) {
            case OPS: {
                SprogCSThrottleManager sprogCSThrottleManager = new SprogCSThrottleManager(this);
                InstanceManager.setThrottleManager(sprogCSThrottleManager);
                this.store(sprogCSThrottleManager, ThrottleManager.class);
                break;
            }
            case SERVICE: {
                SprogThrottleManager sprogThrottleManager = new SprogThrottleManager(this);
                InstanceManager.setThrottleManager(sprogThrottleManager);
                this.store(sprogThrottleManager, ThrottleManager.class);
                break;
            }
            default: {
                log.warn("Unhandled programming mode: {}", (Object)this.sprogMode);
            }
        }
        this.register();
    }

    public SprogProgrammerManager getProgrammerManager() {
        return (SprogProgrammerManager)this.classObjectMap.computeIfAbsent(SprogProgrammerManager.class, c -> new SprogProgrammerManager(new SprogProgrammer(this), this.sprogMode, this));
    }

    public void setProgrammerManager(SprogProgrammerManager p) {
        this.store(p, SprogProgrammerManager.class);
    }

    public SprogPowerManager getPowerManager() {
        return (SprogPowerManager)this.get(PowerManager.class);
    }

    public ThrottleManager getThrottleManager() {
        return this.get(ThrottleManager.class);
    }

    public TurnoutManager getTurnoutManager() {
        return this.get(TurnoutManager.class);
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.sprog.SprogActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void dispose() {
        if (this.st != null) {
            this.st.dispose();
        }
        this.st = null;
        InstanceManager.deregister(this, SprogSystemConnectionMemo.class);
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
        }
        super.dispose();
    }

    public SprogVersionQuery getSprogVersionQuery() {
        if (this.svq == null) {
            this.svq = new SprogVersionQuery(this);
        }
        return this.svq;
    }
}

