/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.NmraPacket;
import jmri.PowerManager;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.sprog.SprogCommandStation;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogThrottle
extends AbstractThrottle {
    SprogCommandStation station = null;
    DccLocoAddress address;
    private static final Logger log = LoggerFactory.getLogger(SprogThrottle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SprogThrottle(SprogSystemConnectionMemo memo, DccLocoAddress address) {
        super(memo, SprogConstants.MAX_FUNCTIONS);
        this.station = memo.getCommandStation();
        SprogThrottle sprogThrottle = this;
        synchronized (sprogThrottle) {
            this.speedSetting = 0.0f;
        }
        this.address = address;
        this.isForward = true;
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    protected void sendFunctionGroup1() {
        byte[] result = NmraPacket.function0Through4Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunction(0), this.getFunction(1), this.getFunction(2), this.getFunction(3), this.getFunction(4));
        this.station.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup2() {
        byte[] result = NmraPacket.function5Through8Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunction(5), this.getFunction(6), this.getFunction(7), this.getFunction(8));
        this.station.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup3() {
        byte[] result = NmraPacket.function9Through12Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunction(9), this.getFunction(10), this.getFunction(11), this.getFunction(12));
        this.station.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup4() {
        byte[] result = NmraPacket.function13Through20Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunction(13), this.getFunction(14), this.getFunction(15), this.getFunction(16), this.getFunction(17), this.getFunction(18), this.getFunction(19), this.getFunction(20));
        this.station.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup5() {
        byte[] result = NmraPacket.function21Through28Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunction(21), this.getFunction(22), this.getFunction(23), this.getFunction(24), this.getFunction(25), this.getFunction(26), this.getFunction(27), this.getFunction(28));
        this.station.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup6() {
        byte[] result = NmraPacket.function29Through36Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunctionNoWarn(29), this.getFunctionNoWarn(30), this.getFunctionNoWarn(31), this.getFunctionNoWarn(32), this.getFunctionNoWarn(33), this.getFunctionNoWarn(34), this.getFunctionNoWarn(35), this.getFunctionNoWarn(36));
        this.station.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup7() {
        byte[] result = NmraPacket.function37Through44Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunctionNoWarn(37), this.getFunctionNoWarn(38), this.getFunctionNoWarn(39), this.getFunctionNoWarn(40), this.getFunctionNoWarn(41), this.getFunctionNoWarn(42), this.getFunctionNoWarn(43), this.getFunctionNoWarn(44));
        this.station.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup8() {
        byte[] result = NmraPacket.function45Through52Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunctionNoWarn(45), this.getFunctionNoWarn(46), this.getFunctionNoWarn(47), this.getFunctionNoWarn(48), this.getFunctionNoWarn(49), this.getFunctionNoWarn(50), this.getFunctionNoWarn(51), this.getFunctionNoWarn(52));
        this.station.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup9() {
        byte[] result = NmraPacket.function53Through60Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunctionNoWarn(53), this.getFunctionNoWarn(54), this.getFunctionNoWarn(55), this.getFunctionNoWarn(56), this.getFunctionNoWarn(57), this.getFunctionNoWarn(58), this.getFunctionNoWarn(59), this.getFunctionNoWarn(60));
        this.station.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup10() {
        byte[] result = NmraPacket.function61Through68Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunctionNoWarn(61), this.getFunctionNoWarn(62), this.getFunctionNoWarn(63), this.getFunctionNoWarn(64), this.getFunctionNoWarn(65), this.getFunctionNoWarn(66), this.getFunctionNoWarn(67), this.getFunctionNoWarn(68));
        this.station.sendPacket(result, 1);
    }

    @Override
    public void setSpeedStepMode(SpeedStepMode Mode) {
        int mode = this.address.isLongAddress() ? 4096 : 0;
        try {
            mode |= InstanceManager.getDefault(PowerManager.class).getPower() == 2 ? 16 : 0;
        }
        catch (Exception e) {
            log.error("Exception from InstanceManager.getDefault(jmri.PowerManager.class)", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Speed Step Mode Change to Mode: {} Current mode is: {}", (Object)Mode, (Object)this.speedStepMode);
        }
        if (Mode == SpeedStepMode.NMRA_DCC_14) {
            mode += 512;
        } else {
            if (Mode == SpeedStepMode.NMRA_DCC_27) {
                log.error("Requested Speed Step Mode 27 not supported Current mode is: {}", (Object)this.speedStepMode);
                return;
            }
            mode = Mode == SpeedStepMode.NMRA_DCC_28 ? (mode += 1024) : (mode += 2048);
        }
        SprogMessage m = new SprogMessage("M h" + Integer.toHexString(mode));
        ((SprogSystemConnectionMemo)this.adapterMemo).getSprogTrafficController().sendSprogMessage(m, null);
        if (Mode != SpeedStepMode.NMRA_DCC_27) {
            this.speedStepMode = Mode;
            this.firePropertyChange("SpeedSteps", (Object)this.speedStepMode, (Object)this.speedStepMode);
        }
    }

    @Override
    public synchronized void setSpeedSetting(float speed) {
        SpeedStepMode mode = this.getSpeedStepMode();
        if (mode == SpeedStepMode.NMRA_DCC_28) {
            float oldSpeed = this.speedSetting;
            this.speedSetting = speed;
            int value = Math.round(28.0f * speed);
            if (this.speedSetting > 0.0f && value == 0) {
                value = 1;
            }
            log.debug("Speed: {} value: {}", (Object)Float.valueOf(speed), (Object)value);
            if (value > 0) {
                value += 3;
            }
            if (value > 31) {
                value = 31;
            }
            if (value < 0) {
                value = 1;
            }
            String step = "" + value;
            SprogMessage m = new SprogMessage(1 + step.length());
            int i = 0;
            if (this.isForward) {
                m.setElement(i++, 62);
            } else {
                m.setElement(i++, 60);
            }
            for (int j = 0; j < step.length(); ++j) {
                m.setElement(i++, step.charAt(j));
            }
            ((SprogSystemConnectionMemo)this.adapterMemo).getSprogTrafficController().sendSprogMessage(m, null);
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        } else {
            float oldSpeed = this.speedSetting;
            this.speedSetting = speed;
            int value = Math.round(126.0f * speed);
            if (this.speedSetting > 0.0f && value == 0) {
                value = 1;
            }
            if (value > 0) {
                ++value;
            }
            if (value > 127) {
                value = 127;
            }
            if (value < 0) {
                value = 1;
            }
            String step = "" + value;
            SprogMessage m = new SprogMessage(1 + step.length());
            int i = 0;
            if (this.isForward) {
                m.setElement(i++, 62);
            } else {
                m.setElement(i++, 60);
            }
            for (int j = 0; j < step.length(); ++j) {
                m.setElement(i++, step.charAt(j));
            }
            ((SprogSystemConnectionMemo)this.adapterMemo).getSprogTrafficController().sendSprogMessage(m, null);
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        }
        this.record(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        SprogThrottle sprogThrottle = this;
        synchronized (sprogThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    @Override
    public void throttleDispose() {
        this.finishRecord();
    }
}

