/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.SwingUtilities;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.SprogInterface;
import jmri.jmrix.sprog.SprogListener;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogReply;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.serialdriver.SerialDriverAdapter;
import jmri.util.LoggingUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogTrafficController
implements SprogInterface,
Runnable {
    private SprogReply reply = new SprogReply();
    SprogListener lastSender = null;
    private SprogConstants.SprogState sprogState = SprogConstants.SprogState.NORMAL;
    private int lastId;
    private Thread tcThread;
    private final Object lock = new Object();
    private boolean replyAvailable = false;
    public int timeout = SprogConstants.TC_PROG_REPLY_TIMEOUT;
    protected Vector<SprogListener> cmdListeners = new Vector();
    BlockingQueue<MessageTuple> sendQueue = new LinkedBlockingQueue<MessageTuple>();
    private AbstractPortController controller = null;
    protected static volatile SprogTrafficController self = null;
    private SprogSystemConnectionMemo memo = null;
    DataInputStream istream = null;
    OutputStream ostream = null;
    private boolean unsolicited;
    private static final Logger log = LoggerFactory.getLogger(SprogTrafficController.class);

    @SuppressFBWarnings(value={"SC_START_IN_CTOR"}, justification="done at end, waits for data")
    public SprogTrafficController(SprogSystemConnectionMemo adaptermemo) {
        this.memo = adaptermemo;
        this.init();
    }

    private void init() {
        this.resetTimeout();
        this.tcThread = ThreadingUtil.newThread(this);
        this.tcThread.setName("SPROG TC thread");
        this.tcThread.setPriority(9);
        this.tcThread.setDaemon(true);
        log.debug("starting TC thread from {} ", (Object)this, (Object)LoggingUtil.shortenStacktrace(new Exception("traceback"), 6));
        this.tcThread.start();
    }

    @Override
    public boolean status() {
        return this.ostream != null && this.istream != null;
    }

    public boolean isTcThreadAlive() {
        return this.tcThread.isAlive();
    }

    @Override
    public synchronized void addSprogListener(SprogListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        if (!this.cmdListeners.contains(l)) {
            this.cmdListeners.addElement(l);
            log.debug("SprogListener added to {} tc", (Object)this.memo.getUserName());
        }
    }

    @Override
    public synchronized void removeSprogListener(SprogListener l) {
        if (this.cmdListeners.contains(l)) {
            this.cmdListeners.removeElement(l);
        }
    }

    public void resetTimeout() {
        this.timeout = this.memo.getSprogMode() == SprogConstants.SprogMode.OPS ? SprogConstants.TC_OPS_REPLY_TIMEOUT : SprogConstants.TC_PROG_REPLY_TIMEOUT;
    }

    public void setTimeout(int t) {
        this.timeout = t;
    }

    public SprogConstants.SprogState getSprogState() {
        return this.sprogState;
    }

    public void setSprogState(SprogConstants.SprogState s) {
        this.sprogState = s;
        if (s == SprogConstants.SprogState.V4BOOTMODE) {
            SerialDriverAdapter controller = this.getController();
            controller.setHandshake(AbstractSerialPortController.FlowControl.RTSCTS);
        }
        log.debug("Setting sprogState {}", (Object)s);
    }

    public boolean isNormalMode() {
        return this.sprogState == SprogConstants.SprogState.NORMAL;
    }

    public boolean isSIIBootMode() {
        return this.sprogState == SprogConstants.SprogState.SIIBOOTMODE;
    }

    public boolean isV4BootMode() {
        return this.sprogState == SprogConstants.SprogState.V4BOOTMODE;
    }

    private synchronized Vector<SprogListener> getCopyOfListeners() {
        return (Vector)this.cmdListeners.clone();
    }

    protected synchronized void notifyMessage(SprogMessage m, SprogListener originator) {
        for (SprogListener listener : this.getCopyOfListeners()) {
            try {
                if (listener == originator || this.lastSender == listener) continue;
                listener.notifyMessage(m);
            }
            catch (Exception e) {
                log.warn("notify: During dispatch to {}", (Object)listener, (Object)e);
            }
        }
        if (this.lastSender != null && this.lastSender != originator) {
            this.lastSender.notifyMessage(m);
        }
    }

    protected synchronized void notifyReply(SprogReply r) {
        log.debug("notifyReply starts for later, last sender: {}", (Object)this.lastSender);
        Vector<SprogListener> listeners = this.getCopyOfListeners();
        SprogReply replyForLater = r;
        SprogListener senderForLater = this.lastSender;
        Runnable rl = () -> {
            for (SprogListener listener : listeners) {
                try {
                    if (senderForLater == listener) continue;
                    listener.notifyReply(replyForLater);
                }
                catch (Exception e) {
                    log.warn("notify: During dispatch to {}", (Object)listener, (Object)e);
                }
            }
            if (senderForLater != null) {
                senderForLater.notifyReply(replyForLater);
            }
        };
        SwingUtilities.invokeLater(rl);
    }

    protected synchronized void notifyReply(SprogReply r, SprogListener lastSender) {
        log.debug("notifyReply starts for later, last sender: {}", (Object)lastSender);
        Vector<SprogListener> listeners = this.getCopyOfListeners();
        SprogReply replyForLater = r;
        SprogListener senderForLater = lastSender;
        Runnable rl = () -> {
            log.debug("notifyReply starts last sender: {}", (Object)senderForLater);
            for (SprogListener listener : listeners) {
                try {
                    if (senderForLater == listener) continue;
                    log.debug("Notify listener: {} {}", (Object)listener, (Object)r.toString());
                    listener.notifyReply(replyForLater);
                }
                catch (Exception e) {
                    log.warn("notify: During dispatch to {}", (Object)listener, (Object)e);
                }
            }
            if (senderForLater != null) {
                log.debug("notify last sender: {} {}", (Object)senderForLater, (Object)replyForLater.toString());
                senderForLater.notifyReply(replyForLater);
            }
        };
        SwingUtilities.invokeLater(rl);
    }

    public void sendSprogMessage(SprogMessage m) {
        log.debug("Add message to queue: [{}] id: {}", (Object)m.toString(this.isSIIBootMode()), (Object)m.getId());
        try {
            this.sendQueue.add(new MessageTuple(m, null));
        }
        catch (Exception e) {
            log.error("Could not add message to queue", (Throwable)e);
        }
    }

    @Override
    public synchronized void sendSprogMessage(SprogMessage m, SprogListener replyTo) {
        log.debug("Add message to queue: [{}] id: {}", (Object)m.toString(this.isSIIBootMode()), (Object)m.getId());
        try {
            this.sendQueue.add(new MessageTuple(m, replyTo));
        }
        catch (Exception e) {
            log.error("Could not add message to queue", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.debug("Traffic controller queuing thread starts");
        while (true) {
            MessageTuple messageToSend;
            log.debug("Traffic controller queue waiting");
            try {
                messageToSend = new MessageTuple(this.sendQueue.take());
            }
            catch (InterruptedException e) {
                log.debug("Thread interrupted while dequeuing message to send");
                return;
            }
            log.debug("Message dequeued {} id: {}", (Object)messageToSend.message, (Object)messageToSend.message.getId());
            this.lastSender = messageToSend.listener;
            this.lastId = messageToSend.message.getId();
            this.notifyMessage(messageToSend.message, messageToSend.listener);
            this.replyAvailable = false;
            this.sendToInterface(messageToSend.message);
            log.debug("Waiting {} for a reply", (Object)this.timeout);
            try {
                Object e = this.lock;
                synchronized (e) {
                    this.lock.wait(this.timeout);
                }
            }
            catch (InterruptedException e) {
                log.debug("waitingForReply interrupted");
            }
            if (!this.replyAvailable) {
                log.warn("Timeout waiting for reply from hardware in SprogState {}", (Object)this.sprogState);
                continue;
            }
            log.debug("Notified of reply");
        }
    }

    public void sendToInterface(SprogMessage m) {
        try {
            if (this.ostream != null) {
                this.ostream.write(m.getFormattedMessage(this.sprogState));
                log.debug("sendSprogMessage written to ostream");
            } else {
                log.warn("sendMessage: no connection established");
            }
        }
        catch (Exception e) {
            log.warn("sendMessage: Exception: ", (Throwable)e);
        }
    }

    public void connectPort(AbstractPortController p) {
        this.istream = p.getInputStream();
        this.ostream = p.getOutputStream();
        if (this.controller != null) {
            log.warn("connectPort: connect called while connected");
        }
        this.controller = p;
    }

    protected SerialDriverAdapter getController() {
        return (SerialDriverAdapter)this.controller;
    }

    public void disconnectPort(AbstractPortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.controller != p) {
            log.warn("disconnectPort: disconnect called from non-connected SprogPortController");
        }
        this.controller = null;
    }

    public void setAdapterMemo(SprogSystemConnectionMemo adaptermemo) {
        this.memo = adaptermemo;
    }

    public SprogSystemConnectionMemo getAdapterMemo() {
        return this.memo;
    }

    boolean endReply(SprogReply msg) {
        return msg.endNormalReply() || msg.endBootReply();
    }

    public void handleOneIncomingReply() {
        int replyCurrentSize;
        for (int i = replyCurrentSize = this.reply.getNumDataElements(); i < 515 - replyCurrentSize; ++i) {
            try {
                if (this.istream.available() == 0) break;
                byte char1 = this.istream.readByte();
                this.reply.setElement(i, char1);
            }
            catch (Exception e) {
                log.warn("Exception in DATA_AVAILABLE state", (Throwable)e);
            }
            if (!this.endReply(this.reply)) continue;
            this.sendreply();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendreply() {
        log.debug("dispatch reply of length {} in SprogState {}", (Object)this.reply.getNumDataElements(), (Object)this.sprogState);
        if (this.unsolicited) {
            log.debug("Unsolicited Reply");
            this.reply.setUnsolicited();
        }
        this.reply.setId(this.lastId);
        this.notifyReply(this.reply, this.lastSender);
        log.debug("Notify() wait");
        this.replyAvailable = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        this.reply = new SprogReply();
    }

    public void dispose() {
        this.tcThread.interrupt();
        try {
            this.tcThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class MessageTuple {
        private final SprogMessage message;
        private final SprogListener listener;

        public MessageTuple(SprogMessage m, SprogListener l) {
            this.message = m;
            this.listener = l;
        }

        public MessageTuple(MessageTuple mt) {
            this.message = mt.message;
            this.listener = mt.listener;
        }
    }
}

