/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.Turnout;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.sprog.Bundle;
import jmri.jmrix.sprog.SprogCSTurnout;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.SprogTurnout;
import jmri.managers.AbstractTurnoutManager;

public class SprogTurnoutManager
extends AbstractTurnoutManager {
    public SprogTurnoutManager(SprogSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public SprogSystemConnectionMemo getMemo() {
        return (SprogSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to convert systemName '" + systemName + "' to a Turnout address");
        }
        AbstractTurnout t = this.getMemo().getSprogMode() == SprogConstants.SprogMode.OPS ? new SprogCSTurnout(addr, this.getMemo()) : new SprogTurnout(addr, this.getMemo());
        t.setUserName(userName);
        return t;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getBitFromSystemName(systemName) != 0 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return this.validateIntegerSystemNameFormat(systemName, 1, 2044, locale);
    }

    public int getBitFromSystemName(String systemName) {
        try {
            this.validateSystemNameFormat(systemName, Locale.getDefault());
        }
        catch (IllegalArgumentException ex) {
            return 0;
        }
        return Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length()));
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

