/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.pi.pisprogonecs;

import jmri.jmrix.AbstractPortController;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.pi.pisprogonecs.Bundle;
import jmri.jmrix.sprog.serialdriver.SerialDriverAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PiSprogOneCSSerialDriverAdapter
extends SerialDriverAdapter {
    private static final Logger log = LoggerFactory.getLogger(PiSprogOneCSSerialDriverAdapter.class);

    public PiSprogOneCSSerialDriverAdapter() {
        super(SprogConstants.SprogMode.OPS, 115200);
        this.options.put("NumSlots", new AbstractPortController.Option(Bundle.getMessage("MakeLabel", Bundle.getMessage("NumSlotOptions")), new String[]{"16", "8", "32", "48", "64"}, true));
        this.options.put("TrackPowerState", new AbstractPortController.Option(Bundle.getMessage("OptionTrackPowerLabel"), new String[]{Bundle.getMessage("PowerStateOff"), Bundle.getMessage("PowerStateOn")}, true));
        this.getSystemConnectionMemo().setUserName(Bundle.getMessage("PiSprog1CSTitle"));
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{"115,200 bps"};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{115200};
    }

    @Override
    public void configure() {
        String slots = this.getOptionState("NumSlots");
        try {
            this.numSlots = Integer.parseInt(slots);
        }
        catch (NumberFormatException e) {
            log.warn("Could not parse number of slots {}", (Object)e.getMessage());
            this.numSlots = 16;
        }
        super.configure();
    }
}

