/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.serialdriver;

import jmri.JmriException;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.SerialPortDataListener;
import jmri.jmrix.SerialPortEvent;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.SprogPortController;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.SprogTrafficController;
import jmri.jmrix.sprog.serialdriver.Bundle;
import jmri.jmrix.sprog.update.SprogType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDriverAdapter
extends SprogPortController {
    private int baudRate = -1;
    protected int numSlots = 1;
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        super(new SprogSystemConnectionMemo(SprogConstants.SprogMode.SERVICE));
        this.baudRate = 9600;
        this.getSystemConnectionMemo().setUserName(Bundle.getMessage("SprogProgrammerTitle"));
        this.getSystemConnectionMemo().setSprogTrafficController(new SprogTrafficController(this.getSystemConnectionMemo()));
    }

    public SerialDriverAdapter(SprogConstants.SprogMode sm) {
        super(new SprogSystemConnectionMemo(sm));
        this.baudRate = 9600;
        this.getSystemConnectionMemo().setUserName("SPROG");
        this.getSystemConnectionMemo().setSprogTrafficController(new SprogTrafficController(this.getSystemConnectionMemo()));
    }

    public SerialDriverAdapter(SprogConstants.SprogMode sm, int baud, SprogType type) {
        super(new SprogSystemConnectionMemo(sm, type));
        this.baudRate = baud;
        this.getSystemConnectionMemo().setUserName("SPROG");
        this.getSystemConnectionMemo().setSprogTrafficController(new SprogTrafficController(this.getSystemConnectionMemo()));
    }

    public SerialDriverAdapter(SprogConstants.SprogMode sm, int baud) {
        super(new SprogSystemConnectionMemo(sm));
        this.baudRate = baud;
        this.getSystemConnectionMemo().setUserName("SPROG");
        this.getSystemConnectionMemo().setSprogTrafficController(new SprogTrafficController(this.getSystemConnectionMemo()));
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect SPROG to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting SPROG to {} {}", (Object)portName, (Object)this.currentSerialPort);
        this.setBaudRate(this.currentSerialPort, this.baudRate);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.NONE);
        this.currentSerialPort.addDataListener(new SerialPortDataListener(){

            @Override
            public int getListeningEvents() {
                log.trace("getListeningEvents");
                return 1;
            }

            @Override
            public void serialEvent(SerialPortEvent event) {
                log.trace("serial event start");
                SerialDriverAdapter.this.getSystemConnectionMemo().getSprogTrafficController().handleOneIncomingReply();
                log.trace("serial event end");
            }
        });
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    public void setHandshake(AbstractSerialPortController.FlowControl flow) {
        this.setFlowControl(this.currentSerialPort, flow);
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{"9,600 bps"};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{9600};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    @Override
    public void configure() {
        this.getSystemConnectionMemo().getSprogTrafficController().connectPort(this);
        log.debug("Configure command station");
        this.getSystemConnectionMemo().configureCommandStation(this.numSlots, this.getOptionState("TrackPowerState"));
        this.getSystemConnectionMemo().configureManagers();
        if (this.getOptionState("TrackPowerState") != null && this.getOptionState("TrackPowerState").equals(Bundle.getMessage("PowerStateOn"))) {
            try {
                this.getSystemConnectionMemo().getPowerManager().setPower(2);
            }
            catch (JmriException e) {
                log.error("Error setting power on {}", (Object)e.toString());
            }
        }
    }

    @Override
    public void dispose() {
        if (this.getSystemConnectionMemo() != null && this.getSystemConnectionMemo().getSprogTrafficController() != null) {
            this.getSystemConnectionMemo().getSprogTrafficController().dispose();
        }
        super.dispose();
    }
}

