/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.sprogmon;

import jmri.jmrix.AbstractMonFrame;
import jmri.jmrix.sprog.SprogListener;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogReply;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.sprogmon.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogMonFrame
extends AbstractMonFrame
implements SprogListener {
    private SprogSystemConnectionMemo _memo = null;
    private static final Logger log = LoggerFactory.getLogger(SprogMonFrame.class);

    public SprogMonFrame(SprogSystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    protected String title() {
        return Bundle.getMessage("MonitorXTitle", "SPROG");
    }

    @Override
    protected void init() {
        this._memo.getSprogTrafficController().addSprogListener(this);
    }

    @Override
    public void dispose() {
        this._memo.getSprogTrafficController().removeSprogListener(this);
        super.dispose();
    }

    @Override
    public synchronized void notifyMessage(SprogMessage l) {
        this.nextLine("cmd: \"" + l.toString(this._memo.getSprogTrafficController().isSIIBootMode()) + "\"\n", "");
    }

    @Override
    public synchronized void notifyReply(SprogReply l) {
        this.nextLine("rep: \"" + l.toString() + "\"\n", "");
        log.debug("reply heard");
    }
}

