/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.sprognano;

import jmri.jmrix.AbstractPortController;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.serialdriver.SerialDriverAdapter;
import jmri.jmrix.sprog.sprognano.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogNanoSerialDriverAdapter
extends SerialDriverAdapter {
    private static final Logger log = LoggerFactory.getLogger(SprogNanoSerialDriverAdapter.class);

    public SprogNanoSerialDriverAdapter() {
        super(SprogConstants.SprogMode.OPS);
        this.options.put("NumSlots", new AbstractPortController.Option(Bundle.getMessage("MakeLabel", Bundle.getMessage("NumSlotOptions")), new String[]{"16", "8", "32", "48", "64"}, true));
        this.options.put("TrackPowerState", new AbstractPortController.Option(Bundle.getMessage("OptionTrackPowerLabel"), new String[]{Bundle.getMessage("PowerStateOff"), Bundle.getMessage("PowerStateOn")}, true));
        this.getSystemConnectionMemo().setUserName(Bundle.getMessage("SprogNanoCSTitle"));
    }

    @Override
    public void configure() {
        String slots = this.getOptionState("NumSlots");
        try {
            this.numSlots = Integer.parseInt(slots);
        }
        catch (NumberFormatException e) {
            log.warn("Could not parse number of slots {}", (Object)e.getMessage());
            this.numSlots = 16;
        }
        super.configure();
    }
}

