/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.sprogslotmon;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import jmri.jmrix.sprog.SprogSlot;
import jmri.jmrix.sprog.SprogSlotListener;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.sprogslotmon.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogSlotMonDataModel
extends AbstractTableModel
implements SprogSlotListener {
    public static final int SLOTCOLUMN = 0;
    public static final int ADDRCOLUMN = 1;
    public static final int SPDCOLUMN = 2;
    public static final int STATCOLUMN = 3;
    public static final int DIRCOLUMN = 4;
    public static final int NUMCOLUMN = 5;
    private SprogSystemConnectionMemo _memo = null;
    static final Boolean True = Boolean.valueOf("True");
    static final Boolean False = Boolean.valueOf("False");
    private boolean _allSlots = true;
    private static final Logger log = LoggerFactory.getLogger(SprogSlotMonDataModel.class);

    SprogSlotMonDataModel(int row, int column, SprogSystemConnectionMemo memo) {
        this._memo = memo;
        this._memo.getCommandStation().addSlotListener(this);
    }

    @Override
    public int getRowCount() {
        int nMin;
        int nMax = this._memo.getNumSlots();
        if (this._allSlots) {
            return nMax;
        }
        int n = 0;
        for (int i = nMin = 0; i < nMax; ++i) {
            SprogSlot s = this._memo.getCommandStation().slot(i);
            if (s.isFree()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("SlotCol");
            }
            case 1: {
                return Bundle.getMessage("AddressCol");
            }
            case 2: {
                return Bundle.getMessage("SpeedCol");
            }
            case 3: {
                return Bundle.getMessage("StatusCol");
            }
            case 4: {
                return Bundle.getMessage("DirectionCol");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Integer.class;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: 
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        SprogSlot s = this._memo.getCommandStation().slot(this.slotNum(row));
        if (s == null) {
            log.error("slot pointer was null for slot row: {} col: {}", (Object)row, (Object)col);
        }
        switch (col) {
            case 0: {
                return this.slotNum(row);
            }
            case 1: {
                switch (s.slotStatus()) {
                    case 1: {
                        return Integer.toString(s.getAddr()) + "(" + (s.getIsLong() ? Bundle.getMessage("LongAddressChar") : Bundle.getMessage("ShortAddressChar")) + ")";
                    }
                    case 0: {
                        return "-";
                    }
                }
                return Bundle.getMessage("StateError");
            }
            case 2: {
                switch (s.slotStatus()) {
                    case 1: {
                        if (s.isF0to4Packet()) {
                            return "F0to4Pkt";
                        }
                        if (s.isF5to8Packet()) {
                            return "F5to8Pkt";
                        }
                        if (s.isF9to12Packet()) {
                            return "F9to12Pkt";
                        }
                        if (s.isF13to20Packet()) {
                            return "F13to20Pkt";
                        }
                        if (s.isF21to28Packet()) {
                            return "F21to28Pkt";
                        }
                        if (s.isOpsPkt()) {
                            return "OpsPkt";
                        }
                        if (s.isSpeedPacket()) {
                            Object t = s.speed() == 1 ? "(estop) 1" : "          " + s.speed();
                            return ((String)t).substring(((String)t).length() - 9, ((String)t).length());
                        }
                        return Bundle.getMessage("StateError");
                    }
                    case 0: {
                        return "-";
                    }
                }
                return Bundle.getMessage("StateError");
            }
            case 3: {
                switch (s.slotStatus()) {
                    case 1: {
                        return Bundle.getMessage("StateInUse");
                    }
                    case 0: {
                        return Bundle.getMessage("StateFree");
                    }
                }
                return Bundle.getMessage("StateError");
            }
            case 4: {
                switch (s.slotStatus()) {
                    case 1: {
                        if (s.isSpeedPacket()) {
                            return s.isForward() ? Bundle.getMessage("DirColForward") : Bundle.getMessage("DirColReverse");
                        }
                        return "-";
                    }
                    case 0: {
                        return "-";
                    }
                }
                return Bundle.getMessage("StateError");
            }
        }
        log.error("internal state inconsistent with table request for row {}, col {}", (Object)row, (Object)col);
        return null;
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="better to keep cases in column order rather than to combine")
    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: {
                return new JTextField((int)3).getPreferredSize().width;
            }
            case 1: {
                return new JTextField((int)5).getPreferredSize().width;
            }
            case 2: {
                return new JTextField((int)6).getPreferredSize().width;
            }
            case 3: {
                return new JTextField((int)6).getPreferredSize().width;
            }
            case 4: {
                return new JTextField((int)3).getPreferredSize().width;
            }
        }
        return new JLabel((String)" <unknown> ").getPreferredSize().width;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        SprogSlot s = this._memo.getCommandStation().slot(this.slotNum(row));
        if (s == null) {
            log.error("slot pointer was null for slot row: {} col: {}", (Object)row, (Object)col);
            return;
        }
    }

    public void configureTable(JTable slotTable) {
        slotTable.getTableHeader().setReorderingAllowed(true);
        slotTable.setAutoResizeMode(0);
        for (int i = 0; i < slotTable.getColumnCount(); ++i) {
            int width = this.getPreferredWidth(i);
            slotTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        slotTable.sizeColumnsToFit(-1);
    }

    @Override
    public synchronized void notifyChangedSlot(SprogSlot s) {
        int slotNum = -1;
        if (this._allSlots) {
            slotNum = s.getSlotNumber();
        }
        log.debug("Received notification of changed slot: {}", (Object)slotNum);
        Notify r = new Notify(slotNum, this);
        SwingUtilities.invokeLater(r);
    }

    public void showAllSlots(boolean val) {
        this._allSlots = val;
    }

    protected int slotNum(int row) {
        int slotNum;
        int n = -1;
        int nMin = 0;
        int nMax = this._memo.getNumSlots();
        for (slotNum = nMin; slotNum < nMax; ++slotNum) {
            SprogSlot s = this._memo.getCommandStation().slot(slotNum);
            if (this._allSlots || s.slotStatus() != 0) {
                ++n;
            }
            if (n == row) break;
        }
        return slotNum;
    }

    public void dispose() {
        this._memo.getCommandStation().removeSlotListener(this);
    }

    static class Notify
    implements Runnable {
        private int _row;
        AbstractTableModel _model;

        public Notify(int row, AbstractTableModel model) {
            this._row = row;
            this._model = model;
        }

        @Override
        public void run() {
            if (-1 == this._row) {
                this._model.fireTableDataChanged();
            } else {
                this._model.fireTableRowsUpdated(this._row, this._row);
            }
        }
    }
}

