/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.sprogslotmon;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.TableRowSorter;
import jmri.jmrix.sprog.SprogListener;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogReply;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.SprogTrafficController;
import jmri.jmrix.sprog.sprogslotmon.Bundle;
import jmri.jmrix.sprog.sprogslotmon.SprogSlotMonDataModel;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogSlotMonFrame
extends JmriJFrame
implements SprogListener {
    JCheckBox showAllCheckBox = new JCheckBox();
    JButton estopAllButton = new JButton(Bundle.getMessage("ButtonEstopAll"));
    SprogSlotMonDataModel slotModel = null;
    JTable slotTable;
    JScrollPane slotScroll;
    JTextArea status = new JTextArea(Bundle.getMessage("TrackCurrentXString", "---"));
    SprogSystemConnectionMemo _memo = null;
    private SprogTrafficController tc = null;
    private static final int STATUS_PERIOD = 500;
    Timer timer = null;
    private boolean mShown = false;
    private static final Logger log = LoggerFactory.getLogger(SprogSlotMonFrame.class);

    public SprogSlotMonFrame(SprogSystemConnectionMemo memo) {
        this._memo = memo;
        this.tc = memo.getSprogTrafficController();
        this.tc.addSprogListener(this);
        this.slotModel = new SprogSlotMonDataModel(memo.getNumSlots(), 8, this._memo);
        this.slotTable = new JTable(this.slotModel);
        this.slotTable.setRowSorter(new TableRowSorter<SprogSlotMonDataModel>(this.slotModel));
        this.slotScroll = new JScrollPane(this.slotTable);
        this.showAllCheckBox.setText(Bundle.getMessage("ButtonShowUnusedSlots"));
        this.showAllCheckBox.setVisible(true);
        this.showAllCheckBox.setSelected(true);
        this.showAllCheckBox.setToolTipText(Bundle.getMessage("ButtonShowSlotsTooltip"));
        this.slotModel.configureTable(this.slotTable);
        this.showAllCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SprogSlotMonFrame.this.slotModel.showAllSlots(SprogSlotMonFrame.this.showAllCheckBox.isSelected());
                SprogSlotMonFrame.this.slotModel.fireTableDataChanged();
            }
        });
        this.estopAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.debug("Estop all button pressed");
                SprogSlotMonFrame.this._memo.getCommandStation().estopAll();
            }
        });
        this.estopAllButton.addMouseListener(JmriMouseListener.adapt(new JmriMouseListener(){

            @Override
            public void mousePressed(JmriMouseEvent e) {
                SprogSlotMonFrame.this._memo.getCommandStation().estopAll();
            }

            @Override
            public void mouseExited(JmriMouseEvent e) {
            }

            @Override
            public void mouseEntered(JmriMouseEvent e) {
            }

            @Override
            public void mouseReleased(JmriMouseEvent e) {
            }

            @Override
            public void mouseClicked(JmriMouseEvent e) {
            }
        }));
        this.slotModel.showAllSlots(this.showAllCheckBox.isSelected());
        this.setTitle(Bundle.getMessage("SprogSlotMonitorTitle"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new FlowLayout());
        pane1.add(this.showAllCheckBox);
        pane1.add(this.estopAllButton);
        pane1.add(this.status);
        this.getContentPane().add(pane1);
        this.getContentPane().add(this.slotScroll);
        this.setHelp();
        this.pack();
        pane1.setMaximumSize(pane1.getSize());
        this.pack();
        this.startTimer(500);
    }

    protected void setHelp() {
        this.addHelpMenu("package.jmri.jmrix.sprog.sprogslotmon.SprogSlotMonFrame", true);
    }

    public void update() {
        this.slotModel.fireTableDataChanged();
    }

    public void updateStatus(String a) {
        this.status.setText(Bundle.getMessage("TrackCurrentXString", a));
    }

    @Override
    public void notifyMessage(SprogMessage m) {
    }

    @Override
    public void notifyReply(SprogReply m) {
        int[] statusA = new int[4];
        String s = m.toString();
        log.debug("Reply received: {}", (Object)s);
        if (s.indexOf(83) > -1) {
            log.debug("Status reply");
            int i = s.indexOf(104);
            if (i > -1) {
                int milliAmps;
                statusA[0] = milliAmps = (int)((double)Integer.decode("0x" + s.substring(i + 7, i + 11)).intValue() * this.tc.getAdapterMemo().getSprogType().getCurrentMultiplier());
                String ampString = Float.toString((float)statusA[0] / 1000.0f);
                this.updateStatus(ampString);
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int jMenuBarHeight = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += jMenuBarHeight;
            this.setSize(dimension);
        }
        this.mShown = true;
    }

    @Override
    public void dispose() {
        this.stopTimer();
        if (this.slotModel != null) {
            this.slotModel.dispose();
        }
        this.slotModel = null;
        this.slotTable = null;
        this.slotScroll = null;
        if (this.tc != null) {
            this.tc.removeSprogListener(this);
        }
        super.dispose();
    }

    protected synchronized void timeout() {
        Runnable r = () -> {
            log.debug("Sending status request");
            this.tc.sendSprogMessage(SprogMessage.getStatus(), this);
        };
        SwingUtilities.invokeLater(r);
    }

    protected void startTimer(int delay) {
        log.debug("Restart timer");
        if (this.timer == null) {
            this.timer = new Timer(delay, e -> this.timeout());
        }
        this.timer.stop();
        this.timer.setInitialDelay(delay);
        this.timer.setRepeats(true);
        this.timer.start();
    }

    protected void stopTimer() {
        log.debug("Stop timer");
        if (this.timer != null) {
            this.timer.stop();
        }
    }
}

