/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.update;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import jmri.jmrix.sprog.update.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogHexFile
extends JmriJFrame {
    private File file;
    private FileInputStream in;
    private BufferedInputStream buffIn;
    private FileOutputStream out;
    private BufferedOutputStream buffOut;
    private int address = 0;
    private int type;
    private int len;
    private int[] data;
    private boolean read;
    private int lineNo = 0;
    private int charIn;
    private String name;
    static final byte EXT_ADDR = 4;
    static final byte DATA = 0;
    static final byte END = 1;
    private static final int MAX_LEN = 520;
    private static final int LEN = 0;
    private static final int ADDRH = 1;
    private static final int ADDRL = 2;
    private static final int TYPE = 3;
    private static final Logger log = LoggerFactory.getLogger(SprogHexFile.class);

    public SprogHexFile(String fileName) {
        this.name = fileName;
        this.file = new File(fileName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean openRd() {
        this.read = true;
        try {
            this.in = new FileInputStream(this.file);
            this.buffIn = new BufferedInputStream(this.in);
            this.address = 0;
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean openWr() {
        this.read = false;
        try {
            this.out = new FileOutputStream(this.file);
            this.buffOut = new BufferedOutputStream(this.out);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void close() {
        try {
            if (this.read) {
                this.buffIn.close();
                this.in.close();
            } else {
                this.buffOut.flush();
                this.buffOut.close();
                this.out.close();
            }
            this.name = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    public int read() {
        int[] record = new int[520];
        do {
            record = this.readLine();
            if (this.type != 4) continue;
            this.address &= 65535 + record[4] * 256 * 65536 + record[5] * 65536;
            record = this.readLine();
        } while (this.type != 0 && this.type != 1);
        if (this.type == 1) {
            return 0;
        }
        this.data = new int[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.data[i] = record[4 + i];
        }
        return this.len;
    }

    public int[] readLine() {
        int fileCheck;
        int checksum;
        int[] record;
        block8: {
            record = new int[520];
            checksum = 0;
            try {
                while ((this.charIn = this.buffIn.read()) == 13 || this.charIn == 10) {
                }
                if (this.charIn != 58) {
                    if (log.isDebugEnabled()) {
                        log.debug("HexFile.readLine no colon at start of line {}", (Object)this.lineNo);
                    }
                    return new int[]{-1};
                }
            }
            catch (IOException e) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("IoErrorReadingHexFile"), Bundle.getMessage("ErrorTitle"), 0);
                if (!log.isDebugEnabled()) break block8;
                log.debug("I/O Error reading hex file!{}", (Object)e.toString());
            }
        }
        record[0] = this.rdHexByte();
        checksum += record[0];
        record[1] = this.rdHexByte();
        checksum += record[1];
        record[2] = this.rdHexByte();
        checksum += record[2];
        record[3] = this.rdHexByte();
        checksum += record[3];
        this.address = (this.address & 0xFFFF0000) + record[1] * 256 + record[2];
        this.type = record[3];
        if (this.type != 1) {
            this.len = record[0];
            for (int i = 1; i <= this.len; ++i) {
                record[3 + i] = this.rdHexByte();
                checksum += record[3 + i];
            }
        }
        if ((checksum + (fileCheck = this.rdHexByte()) & 0xFF) != 0) {
            log.error("HexFile.readLine bad checksum at line {}", (Object)this.lineNo);
        }
        ++this.lineNo;
        return record;
    }

    private int rdHexByte() {
        int hi = this.rdHexDigit();
        int lo = this.rdHexDigit();
        if (hi < 16 && lo < 16) {
            return hi * 16 + lo;
        }
        return 0;
    }

    private int rdHexDigit() {
        int b = 0;
        try {
            b = this.buffIn.read();
            if (b >= 48 && b <= 57) {
                b -= 48;
            } else if (b >= 65 && b <= 70) {
                b = b - 65 + 10;
            } else if (b >= 97 && b <= 102) {
                b = b - 97 + 10;
            } else {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("InvalidHexDigitAtLine", this.lineNo), Bundle.getMessage("ErrorTitle"), 0);
                log.error("Format Error! Invalid hex digit at line {}", (Object)this.lineNo);
                b = 16;
            }
        }
        catch (IOException e) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("IoErrorReadingHexFile"), Bundle.getMessage("ErrorTitle"), 0);
            log.error("I/O Error reading hex file!{}", (Object)e.toString());
        }
        return (byte)b;
    }

    public void write(int addr, byte type, byte[] data) {
        byte[] record = new byte[data.length + 1 + 2 + 1];
        if (addr / 65536 != this.address / 65536) {
            byte[] extAddr = new byte[]{2, 0, 0, 4, 0, (byte)(addr / 65536)};
            this.writeLine(extAddr);
        }
        this.address = addr;
        record[0] = (byte)data.length;
        record[1] = (byte)(this.address / 256);
        record[2] = (byte)(this.address & 0xFF);
        record[3] = type;
        for (int i = 0; i < data.length; ++i) {
            record[4 + i] = data[i];
        }
        this.writeLine(record);
    }

    public void wrExtAddr(int addr) {
        this.write(0, (byte)4, new byte[]{(byte)(addr / 256), (byte)(addr & 0xFF)});
    }

    public void wrEof() {
        this.writeLine(new byte[]{0, 0, 0, 1});
    }

    public int getRecordType() {
        return this.type;
    }

    public int getLen() {
        return this.len;
    }

    public int getAddress() {
        return this.address;
    }

    public byte getAddressL() {
        return (byte)(this.address & 0xFF);
    }

    public byte getAddressH() {
        return (byte)(this.address / 256 & 0xFF);
    }

    public byte getAddressU() {
        return (byte)(this.address / 65536);
    }

    public int[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    private void writeLine(byte[] data) {
        int checksum = 0;
        try {
            this.buffOut.write(58);
            for (int i = 0; i < data.length; ++i) {
                this.writeHexByte(data[i]);
                checksum += data[i];
            }
            if ((checksum &= 0xFF) > 0) {
                checksum = 256 - checksum;
            }
            this.writeHexByte((byte)checksum);
            this.buffOut.write(10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeHexByte(byte b) {
        int i = b;
        if (b < 0) {
            i = 256 + b;
        }
        this.writeHexDigit((byte)(i / 16));
        this.writeHexDigit((byte)(i & 0xF));
    }

    private void writeHexDigit(byte b) {
        try {
            if (b > 9) {
                this.buffOut.write(b - 9 + 64);
            } else {
                this.buffOut.write(b + 48);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

