/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.update;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Timer;
import jmri.ProgrammerException;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.SprogListener;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogReply;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.SprogTrafficController;
import jmri.jmrix.sprog.update.SprogType;
import jmri.jmrix.sprog.update.SprogVersion;
import jmri.jmrix.sprog.update.SprogVersionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogVersionQuery
implements SprogListener {
    String replyString;
    SprogTrafficController tc;
    SprogVersion ver;
    QueryState state = QueryState.IDLE;
    protected final int LONG_TIMEOUT = 2000;
    Timer timer = null;
    private SprogSystemConnectionMemo _memo = null;
    protected static final Vector<SprogVersionListener> versionListeners = new Vector();
    private static final Logger log = LoggerFactory.getLogger(SprogVersionQuery.class);

    public SprogVersionQuery(SprogSystemConnectionMemo memo) {
        if (log.isDebugEnabled()) {
            log.debug("setting instance: {}", (Object)this);
        }
        this._memo = memo;
        this.tc = this._memo.getSprogTrafficController();
        this.state = QueryState.IDLE;
    }

    protected synchronized void addSprogVersionListener(SprogVersionListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        if (!versionListeners.contains(l)) {
            versionListeners.addElement(l);
        }
    }

    public synchronized void removeSprogVersionListener(SprogVersionListener l) {
        if (versionListeners.contains(l)) {
            versionListeners.removeElement(l);
        }
        if (versionListeners.size() == 0) {
            this.stopTimer();
        }
    }

    private synchronized Vector<SprogVersionListener> getCopyOfListeners() {
        return (Vector)versionListeners.clone();
    }

    public synchronized void requestVersion(SprogVersionListener l) {
        if (log.isDebugEnabled()) {
            log.debug("SprogVersion requested by {}", (Object)l.toString());
        }
        if (this.state == QueryState.DONE) {
            try {
                l.notifyVersion(this.ver);
            }
            catch (ProgrammerException e) {
                log.error("Programmer Exception in non-programming context", (Throwable)e);
            }
            return;
        }
        this.addSprogVersionListener(l);
        if (this.state == QueryState.IDLE) {
            SprogMessage m = new SprogMessage(1);
            m.setOpCode(32);
            this.tc.setTimeout(SprogConstants.TC_BOOT_REPLY_TIMEOUT);
            this.tc.sendSprogMessage(m, this);
            this.state = QueryState.CRSENT;
            this.startLongTimer();
        }
    }

    protected synchronized void notifyVersion(SprogVersion v) {
        this.ver = v;
        for (SprogVersionListener listener : this.getCopyOfListeners()) {
            try {
                try {
                    listener.notifyVersion(this.ver);
                }
                catch (ProgrammerException e) {
                    log.error("Programmer Exception in non-programming context", (Throwable)e);
                }
                versionListeners.remove(listener);
            }
            catch (Exception e) {
                log.warn("notify: During dispatch to {}", (Object)listener, (Object)e);
            }
        }
    }

    @Override
    public void notifyMessage(SprogMessage m) {
    }

    @Override
    public synchronized void notifyReply(SprogReply m) {
        this.replyString = m.toString();
        switch (this.state) {
            case IDLE: {
                if (!log.isDebugEnabled()) break;
                log.debug("reply in IDLE state");
                break;
            }
            case CRSENT: {
                log.debug("reply in CRSENT state {}", (Object)this.replyString);
                if (this.replyString.indexOf("P>") < 0) break;
                this.stopTimer();
                SprogMessage msg = new SprogMessage(1);
                msg.setOpCode(63);
                this.tc.sendSprogMessage(msg, this);
                this.state = QueryState.QUERYSENT;
                this.startLongTimer();
                break;
            }
            case QUERYSENT: {
                log.debug("reply in QUERYSENT state {}", (Object)this.replyString);
                if (this.replyString.contains("SPROG")) {
                    SprogVersion v;
                    this.stopTimer();
                    String[] splits = this.replyString.split("\n");
                    splits = splits[1].split(" ");
                    int index = 1;
                    log.debug("Elements in version reply: {}", (Object)splits.length);
                    log.debug("First element: <{}>", (Object)splits[0]);
                    if (splits[0].contains("Pi-SPROG")) {
                        log.debug("Found a Pi-SPROG {}", (Object)splits[index]);
                        switch (splits[1]) {
                            case "Nano": {
                                v = new SprogVersion(new SprogType(1001), splits[2].substring(1));
                                break;
                            }
                            case "One": {
                                v = new SprogVersion(new SprogType(60), splits[2].substring(1));
                                break;
                            }
                            default: {
                                if (log.isDebugEnabled()) {
                                    log.debug("Unrecognised Pi-SPROG {}", (Object)splits[1]);
                                }
                                v = new SprogVersion(new SprogType(3));
                                break;
                            }
                        }
                    } else if (splits[0].contains("SPROG")) {
                        log.debug("Found a SPROG {}", (Object)splits[index]);
                        switch (splits[index]) {
                            case "3": {
                                v = new SprogVersion(new SprogType(30), splits[index += 2]);
                                break;
                            }
                            case "IV": {
                                v = new SprogVersion(new SprogType(40), splits[index += 2]);
                                break;
                            }
                            case "5": {
                                v = new SprogVersion(new SprogType(50), splits[index += 2]);
                                break;
                            }
                            case "Nano": {
                                v = new SprogVersion(new SprogType(1000), splits[index += 2]);
                                break;
                            }
                            case "Sniffer": {
                                v = new SprogVersion(new SprogType(2000), splits[index += 2]);
                                break;
                            }
                            case "II": {
                                if (splits[++index].equals("USB")) {
                                    v = new SprogVersion(new SprogType(21), splits[index += 2]);
                                    break;
                                }
                                v = new SprogVersion(new SprogType(20), splits[++index]);
                                break;
                            }
                            case "Ver": {
                                v = new SprogVersion(new SprogType(10), splits[++index]);
                                break;
                            }
                            default: {
                                log.debug("Unrecognised SPROG {}", (Object)splits[index]);
                                v = new SprogVersion(new SprogType(3));
                                break;
                            }
                        }
                    } else {
                        log.warn("Found an unknown SPROG {}", (Object)splits[index]);
                        v = new SprogVersion(new SprogType(3));
                    }
                    if (v.sprogType.sprogType == 20 && v.getMajorVersion() == 3) {
                        v = new SprogVersion(new SprogType(23), v.sprogVersion);
                    } else if (v.sprogType.sprogType == 20 && v.getMajorVersion() >= 4) {
                        v = new SprogVersion(new SprogType(24), v.sprogVersion);
                    }
                    log.debug("Found: {}", (Object)v.toString());
                    this.notifyVersion(v);
                    this.state = QueryState.DONE;
                }
                this.tc.resetTimeout();
                break;
            }
            case DONE: {
                break;
            }
            default: {
                log.error("Unknown case");
            }
        }
    }

    protected synchronized void timeout() {
        switch (this.state) {
            case CRSENT: {
                log.debug("Timeout no SPROG prompt");
                this.state = QueryState.IDLE;
                SprogVersion v = new SprogVersion(new SprogType(4));
                this.notifyVersion(v);
                break;
            }
            case QUERYSENT: {
                log.debug("Timeout no SPROG found");
                this.state = QueryState.IDLE;
                SprogVersion v = new SprogVersion(new SprogType(2));
                this.notifyVersion(v);
                break;
            }
            case IDLE: 
            case DONE: {
                log.error("Timeout in unexpected state: {}", (Object)this.state);
                break;
            }
            default: {
                log.warn("Unhandled timeout state code: {}", (Object)this.state);
            }
        }
        this.tc.resetTimeout();
    }

    protected void startLongTimer() {
        this.restartTimer(2000);
    }

    protected void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    protected void restartTimer(int delay) {
        if (this.timer == null) {
            this.timer = new Timer(delay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SprogVersionQuery.this.timeout();
                }
            });
        }
        this.timer.stop();
        this.timer.setInitialDelay(delay);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    static enum QueryState {
        IDLE,
        CRSENT,
        QUERYSENT,
        DONE;

    }
}

