/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp;

import jmri.jmrix.AbstractMRMessage;

public class SRCPMessage
extends AbstractMRMessage {
    static final int LONG_TIMEOUT = 180000;

    public SRCPMessage() {
    }

    public SRCPMessage(int i) {
        super(i);
    }

    public SRCPMessage(SRCPMessage m) {
        super(m);
    }

    public SRCPMessage(String m) {
        super(m);
    }

    public boolean isKillMain() {
        String s = this.toString();
        return s.contains("POWER OFF") && s.contains("SET");
    }

    public boolean isEnableMain() {
        String s = this.toString();
        return s.contains("POWER ON") && s.contains("SET");
    }

    public static SRCPMessage getEnableMain() {
        SRCPMessage m = new SRCPMessage("SET 1 POWER ON\n");
        m.setBinary(false);
        return m;
    }

    public static SRCPMessage getKillMain() {
        SRCPMessage m = new SRCPMessage("SET 1 POWER OFF\n");
        m.setBinary(false);
        return m;
    }

    public static SRCPMessage getProgMode(int bus) {
        String msg = "INIT " + bus + " SM NMRA\n";
        SRCPMessage m = new SRCPMessage(msg);
        return m;
    }

    public static SRCPMessage getExitProgMode(int bus) {
        String msg = "TERM " + bus + " SM\n";
        SRCPMessage m = new SRCPMessage(msg);
        return m;
    }

    public static SRCPMessage getReadDirectCV(int bus, int cv) {
        String msg = "GET " + bus + " SM 0 CV " + cv + "\n";
        SRCPMessage m = new SRCPMessage(msg);
        m.setTimeout(180000);
        return m;
    }

    public static SRCPMessage getConfirmDirectCV(int bus, int cv, int val) {
        String msg = "VERIFY " + bus + " SM 0 CV " + cv + " " + val + "\n";
        SRCPMessage m = new SRCPMessage(msg);
        m.setTimeout(180000);
        return m;
    }

    public static SRCPMessage getWriteDirectCV(int bus, int cv, int val) {
        String msg = "SET " + bus + " SM 0 CV " + cv + " " + val + "\n";
        SRCPMessage m = new SRCPMessage(msg);
        m.setTimeout(180000);
        return m;
    }

    public static SRCPMessage getReadDirectBitCV(int bus, int cv, int bit) {
        String msg = "GET " + bus + " SM 0 CVBIT " + cv + " " + bit + "\n";
        SRCPMessage m = new SRCPMessage(msg);
        m.setTimeout(180000);
        return m;
    }

    public static SRCPMessage getConfirmDirectBitCV(int bus, int cv, int bit, int val) {
        String msg = "VERIFY " + bus + " SM 0 CVBIT " + cv + " " + bit + " " + val + "\n";
        SRCPMessage m = new SRCPMessage(msg);
        m.setTimeout(180000);
        return m;
    }

    public static SRCPMessage getWriteDirectBitCV(int bus, int cv, int bit, int val) {
        String msg = "SET " + bus + " SM 0 CVBIT " + cv + " " + bit + " " + val + "\n";
        SRCPMessage m = new SRCPMessage(msg);
        m.setTimeout(180000);
        return m;
    }

    public static SRCPMessage getReadRegister(int bus, int reg) {
        if (reg > 8) {
            throw new IllegalArgumentException("register number too large: " + reg);
        }
        String msg = "GET " + bus + " SM 0 REG " + reg + "\n";
        SRCPMessage m = new SRCPMessage(msg);
        m.setTimeout(180000);
        return m;
    }

    public static SRCPMessage getConfirmRegister(int bus, int reg, int val) {
        if (reg > 8) {
            throw new IllegalArgumentException("register number too large: " + reg);
        }
        String msg = "VERIFY " + bus + " SM 0 REG " + reg + " " + val + "\n";
        SRCPMessage m = new SRCPMessage(msg);
        m.setTimeout(180000);
        return m;
    }

    public static SRCPMessage getWriteRegister(int bus, int reg, int val) {
        if (reg > 8) {
            throw new IllegalArgumentException("register number too large: " + reg);
        }
        String msg = "SET " + bus + " SM 0 REG " + reg + " " + val + "\n";
        SRCPMessage m = new SRCPMessage(msg);
        m.setTimeout(180000);
        return m;
    }
}

