/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp;

import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.srcp.parser.SimpleNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRCPReply
extends AbstractMRReply {
    private static final Logger log = LoggerFactory.getLogger(SRCPReply.class);

    public SRCPReply() {
    }

    public SRCPReply(String s) {
        super(s);
    }

    public SRCPReply(SRCPReply l) {
        super(l);
    }

    public SRCPReply(SimpleNode n) {
        log.debug("Parser Constructor called with node type {} and {} children.", n.getClass(), (Object)n.jjtGetNumChildren());
        String s = this.inOrderTraversal(n);
        log.debug("Parser Constructor built :{}", (Object)s);
        this._nDataChars = s.length();
        for (int i = 0; i < this._nDataChars; ++i) {
            this._dataChars[i] = s.charAt(i);
        }
    }

    private String inOrderTraversal(SimpleNode n) {
        StringBuilder b;
        if (n.jjtGetNumChildren() > 1) {
            b = new StringBuilder((String)n.jjtGetValue());
            for (int i = 0; i < n.jjtGetNumChildren(); ++i) {
                if (i != 0) {
                    b.append(" ");
                }
                b.append(this.inOrderTraversal((SimpleNode)n.jjtGetChild(i)));
            }
        } else {
            try {
                b = new StringBuilder((String)n.jjtGetValue());
            }
            catch (NullPointerException npe) {
                b = new StringBuilder("");
            }
        }
        return b.toString();
    }

    public boolean isResponseOK() {
        return this.getResponseCode().charAt(0) == '1' || this.getResponseCode().charAt(0) == '2';
    }

    public String getResponseCode() {
        String[] part = this.toString().split("\\s", 3);
        return part[1];
    }

    @Override
    protected int skipPrefix(int index) {
        while (index < this.getNumDataElements() - 1 && (char)this.getElement(index) <= ' ') {
            ++index;
        }
        return index;
    }

    @Override
    public int value() {
        String s = this.toString();
        String[] part = s.split("\\s", 10);
        int val = -1;
        try {
            int tmp;
            val = tmp = Integer.valueOf(part[7], 10).intValue();
        }
        catch (Exception e) {
            log.error("Unable to get number from reply: \"{}\"", (Object)s);
        }
        return val;
    }

    @Override
    public boolean isUnsolicited() {
        String s = this.toString();
        try {
            String[] part = s.split("\\s", 7);
            if (part[2].equals("SRCP")) {
                this.setUnsolicited();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

