/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.srcp.SRCPBusConnectionMemo;
import jmri.jmrix.srcp.SRCPSensor;
import jmri.managers.AbstractSensorManager;

public class SRCPSensorManager
extends AbstractSensorManager {
    public SRCPSensorManager(SRCPBusConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public SRCPBusConnectionMemo getMemo() {
        return (SRCPBusConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unable to convert " + systemName.substring(this.getSystemPrefix().length() + 1) + " to SRCP sensor address");
        }
        SRCPSensor t = new SRCPSensor(addr, this.getMemo());
        t.setUserName(userName);
        return t;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateSystemNameFormatOnlyNumeric(name, locale);
    }
}

