/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp;

import java.util.EnumSet;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.srcp.SRCPBusConnectionMemo;
import jmri.jmrix.srcp.SRCPMessage;
import jmri.jmrix.srcp.SRCPThrottle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRCPThrottleManager
extends AbstractThrottleManager {
    private int bus;
    private static final Logger log = LoggerFactory.getLogger(SRCPThrottleManager.class);

    public SRCPThrottleManager(SRCPBusConnectionMemo memo) {
        super(memo);
        this.bus = memo.getBus();
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        log.debug("new SRCPThrottle for {}", (Object)address);
        if (!(address instanceof DccLocoAddress)) {
            throw new IllegalArgumentException("Request for throttle for unsupported non-DCC address.");
        }
        this.notifyThrottleKnown(new SRCPThrottle((SRCPBusConnectionMemo)this.adapterMemo, (DccLocoAddress)address), address);
    }

    @Override
    public boolean hasDispatchFunction() {
        return false;
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return SRCPThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return !SRCPThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean addressTypeUnique() {
        return true;
    }

    static boolean isLongAddress(int num) {
        return num >= 100;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128, SpeedStepMode.NMRA_DCC_28, SpeedStepMode.NMRA_DCC_27, SpeedStepMode.NMRA_DCC_14);
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        if (super.disposeThrottle(t, l)) {
            DccLocoAddress la = (DccLocoAddress)t.getLocoAddress();
            String msg = "TERM " + this.bus + " GL " + la.getNumber() + "\n";
            ((SRCPBusConnectionMemo)this.adapterMemo).getTrafficController().sendSRCPMessage(new SRCPMessage(msg), null);
            return true;
        }
        return false;
    }
}

