/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp;

import jmri.implementation.AbstractTurnout;
import jmri.jmrix.srcp.SRCPBusConnectionMemo;
import jmri.jmrix.srcp.SRCPMessage;
import jmri.jmrix.srcp.SRCPTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRCPTurnout
extends AbstractTurnout {
    private int _number;
    private int _bus;
    private SRCPTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(SRCPTurnout.class);

    public SRCPTurnout(int number, SRCPBusConnectionMemo memo) {
        super(memo.getSystemPrefix() + memo.getTurnoutManager().typeLetter() + number);
        this._number = number;
        this._bus = memo.getBus();
        this.tc = memo.getTrafficController();
        String text = "INIT " + this._bus + " GA " + this._number + " N\n";
        this.tc.sendSRCPMessage(new SRCPMessage(text), null);
    }

    public int getNumber() {
        return this._number;
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both CLOSED and THROWN {}", (Object)newState);
                return;
            }
            this.sendMessage(!this.getInverted());
        } else {
            this.sendMessage(this.getInverted());
        }
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        log.debug("Send command to {} Pushbutton {}T{}", new Object[]{_pushButtonLockout ? "Lock" : "Unlock", this.tc.getSystemConnectionMemo().getSystemPrefix(), this._number});
    }

    protected void sendMessage(boolean closed) {
        String text = closed ? "SET " + this._bus + " GA " + this._number + " 0 0 -1\n" : "SET " + this._bus + " GA " + this._number + " 0 1 -1\n";
        this.tc.sendSRCPMessage(new SRCPMessage(text), null);
    }
}

