/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.IndexedPropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import jmri.InstanceManager;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.JmrixConfigPane;
import jmri.profile.ProfileManager;
import jmri.swing.ManagingPreferencesPanel;
import jmri.swing.PreferencesPanel;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionsPreferencesPanel
extends JTabbedPane
implements ManagingPreferencesPanel {
    private static final ResourceBundle rb = ResourceBundle.getBundle("apps.AppsConfigBundle");
    private final ImageIcon deleteIcon;
    private final ImageIcon deleteIconRollOver;
    private final Dimension deleteButtonSize;
    private ImageIcon addIcon;
    private boolean restartRequired = false;
    private ArrayList<JmrixConfigPane> configPanes = new ArrayList();
    transient ChangeListener addTabListener = evt -> {
        JTabbedPane pane = (JTabbedPane)evt.getSource();
        int sel = pane.getSelectedIndex();
        if (sel == -1) {
            this.addConnectionTab();
            return;
        }
        Icon icon = pane.getIconAt(sel);
        if (icon == this.addIcon) {
            this.addConnectionTab();
            return;
        }
        this.activeTab();
    };
    private static final Logger log = LoggerFactory.getLogger(ConnectionsPreferencesPanel.class);

    public ConnectionsPreferencesPanel() {
        this.deleteIconRollOver = new ImageIcon(FileUtil.findURL("program:resources/icons/misc/gui3/Delete16x16.png"));
        this.deleteIcon = new ImageIcon(FileUtil.findURL("program:resources/icons/misc/gui3/Delete-bw16x16.png"));
        this.deleteButtonSize = new Dimension(this.deleteIcon.getIconWidth() + 2, this.deleteIcon.getIconHeight() + 2);
        this.addIcon = new ImageIcon(FileUtil.findURL("program:resources/icons/misc/gui3/Add16x16.png"));
        ConnectionConfigManager ccm = InstanceManager.getDefault(ConnectionConfigManager.class);
        ConnectionConfig[] connections = ccm.getConnections();
        if (connections.length != 0) {
            for (int i = 0; i < connections.length; ++i) {
                this.addConnection(i, JmrixConfigPane.createPanel(i));
            }
        } else {
            this.addConnection(0, JmrixConfigPane.createNewPanel());
        }
        ccm.addPropertyChangeListener("connections", evt -> {
            int i = ((IndexedPropertyChangeEvent)evt).getIndex();
            log.debug("PrefPanel ChangeListener of tab index i = {} of {} list", (Object)(i + 1), (Object)this.configPanes.size());
            if (evt.getOldValue() == null && evt.getNewValue() != null) {
                for (JmrixConfigPane pane : this.configPanes) {
                    if (pane.getCurrentObject() == null) {
                        log.error("did not expect pane.getCurrentObject()==null here for {} {} {}", new Object[]{i, evt.getNewValue(), this.configPanes});
                        continue;
                    }
                    if (!pane.getCurrentObject().equals(evt.getNewValue())) continue;
                    return;
                }
                this.addConnection(i, JmrixConfigPane.createPanel(i));
            }
        });
        this.addChangeListener(this.addTabListener);
        this.newConnectionTab();
        this.setSelectedIndex(0);
    }

    private void activeTab() {
        for (int i = 0; i < this.getTabCount() - 1; ++i) {
            Component[] comp;
            JPanel panel = (JPanel)this.getTabComponentAt(i);
            if (panel == null) continue;
            panel.invalidate();
            for (Component c : comp = panel.getComponents()) {
                if (!(c instanceof JButton)) continue;
                if (i == this.getSelectedIndex()) {
                    c.setVisible(true);
                    continue;
                }
                c.setVisible(false);
            }
        }
    }

    private void addConnection(int tabPosition, JmrixConfigPane configPane) {
        Object title;
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)configPane, "Center");
        JButton tabCloseButton = new JButton(this.deleteIcon);
        tabCloseButton.setPreferredSize(this.deleteButtonSize);
        tabCloseButton.setBorderPainted(false);
        tabCloseButton.setRolloverIcon(this.deleteIconRollOver);
        tabCloseButton.setVisible(false);
        JPanel c = new JPanel();
        c.setLayout(new FlowLayout(0, 0, 0));
        JCheckBox disable = new JCheckBox(rb.getString("ButtonDisableConnection"));
        disable.setSelected(configPane.getDisabled());
        disable.addActionListener(e -> configPane.setDisabled(disable.isSelected()));
        c.add(disable);
        p.add((Component)c, "South");
        if (configPane.getConnectionName() != null) {
            title = configPane.getConnectionName();
        } else if (configPane.getCurrentProtocolName() != null && !configPane.getCurrentProtocolName().equals(JmrixConfigPane.NONE)) {
            title = configPane.getCurrentProtocolName();
        } else {
            title = rb.getString("TabbedLayoutConnection") + (tabPosition + 1);
            if (this.indexOfTab((String)title) != -1) {
                for (int x = 2; x < 12 && this.indexOfTab((String)(title = rb.getString("TabbedLayoutConnection") + (tabPosition + 2))) == -1; ++x) {
                }
            }
        }
        JPanel tabTitle = new JPanel(new BorderLayout(5, 0));
        tabTitle.setOpaque(false);
        p.setName((String)title);
        if (configPane.getDisabled()) {
            title = "(" + (String)title + ")";
        }
        JLabel tabLabel = new JLabel((String)title, 2);
        tabTitle.add((Component)tabLabel, "West");
        tabTitle.add((Component)tabCloseButton, "East");
        this.configPanes.add(configPane);
        this.add(p);
        this.setTabComponentAt(tabPosition, tabTitle);
        tabCloseButton.addActionListener(e -> this.removeTab(e, this.indexOfTabComponent(tabTitle)));
        this.setToolTipTextAt(tabPosition, (String)title);
        if (ConnectionStatus.instance().isConnectionOk(null, configPane.getCurrentProtocolInfo())) {
            tabLabel.setForeground(Color.black);
        } else {
            tabLabel.setForeground(Color.red);
        }
        if (configPane.getDisabled()) {
            tabLabel.setForeground(Color.ORANGE);
        }
    }

    void addConnectionTab() {
        this.removeTabAt(this.indexOfTab(this.addIcon));
        this.addConnection(this.configPanes.size(), JmrixConfigPane.createNewPanel());
        this.newConnectionTab();
    }

    private void newConnectionTab() {
        this.addTab(null, this.addIcon, null, rb.getString("ToolTipAddNewConnection"));
        this.setSelectedIndex(this.getTabCount() - 2);
    }

    private void removeTab(ActionEvent e, int x) {
        int i = x;
        if (i != -1) {
            int n;
            if (e != null && (n = JmriJOptionPane.showConfirmDialog(null, MessageFormat.format(rb.getString("MessageDoDelete"), this.getTitleAt(i)), rb.getString("MessageDeleteConnection"), 0)) != 0) {
                return;
            }
            log.debug("i = {}, this.getTabCount() = {}, configPanes.size()={}", new Object[]{i, this.getTabCount(), this.configPanes.size()});
            JmrixConfigPane configPane = this.configPanes.get(i);
            this.removeChangeListener(this.addTabListener);
            this.remove(i);
            log.debug("start of connection #{} disposal", (Object)i);
            try {
                JmrixConfigPane.dispose(configPane);
            }
            catch (NullPointerException ex) {
                log.error("Caught Null Pointer Exception while removing connection tab {}", (Object)i);
            }
            log.debug("connection tab #{} successfully disposed. configPanes.size() = {}", (Object)(i + 1), (Object)this.configPanes.size());
            this.configPanes.remove(i);
            this.restartRequired = true;
            if (this.getTabCount() == 1) {
                this.addConnectionTab();
            }
            if (x != 0) {
                this.setSelectedIndex(x - 1);
            } else {
                this.setSelectedIndex(0);
            }
            this.addChangeListener(this.addTabListener);
        }
        this.activeTab();
    }

    @Override
    public String getPreferencesItem() {
        return "CONNECTIONS";
    }

    @Override
    public String getPreferencesItemText() {
        return rb.getString("MenuConnections");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return null;
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        InstanceManager.getDefault(ConnectionConfigManager.class).savePreferences(ProfileManager.getDefault().getActiveProfile());
    }

    @Override
    public boolean isDirty() {
        return this.configPanes.stream().anyMatch(JmrixConfigPane::isDirty);
    }

    @Override
    public boolean isRestartRequired() {
        return this.restartRequired || this.configPanes.stream().anyMatch(JmrixConfigPane::isRestartRequired);
    }

    @Override
    public boolean isPreferencesValid() {
        return this.configPanes.stream().allMatch(JmrixConfigPane::isPreferencesValid);
    }

    @Override
    public List<PreferencesPanel> getPreferencesPanels() {
        return new ArrayList<PreferencesPanel>(this.configPanes);
    }
}

