/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.tams.TamsMessage;
import jmri.jmrix.tams.TamsProgrammer;
import jmri.jmrix.tams.TamsTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamsOpsModeProgrammer
extends TamsProgrammer
implements AddressedProgrammer {
    int mAddress;
    boolean mLongAddr;
    private static final Logger log = LoggerFactory.getLogger(TamsOpsModeProgrammer.class);

    public TamsOpsModeProgrammer(TamsTrafficController tc, int pAddress, boolean pLongAddr) {
        super(tc);
        log.debug("TAMs ops mode programmer {} {}", (Object)pAddress, (Object)pLongAddr);
        this.mAddress = pAddress;
        this.mLongAddr = pLongAddr;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("write CV={} val={}", (Object)CV, (Object)val);
        }
        this.useProgrammer(p);
        this._progRead = false;
        this._val = val;
        this._cv = CV;
        this.progState = 2;
        this.startShortTimer();
        this.tc.sendTamsMessage(TamsMessage.getWriteOpsModeCVMsg(this.mAddress, CV, val), this);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("read CV={}", (Object)CV);
        }
        log.error("readCV not available in this protocol");
        throw new ProgrammerException();
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        if (log.isDebugEnabled()) {
            log.debug("confirm CV={}", (Object)CV);
        }
        log.error("confirmCV not available in this protocol");
        throw new ProgrammerException();
    }

    @Override
    protected void notifyProgListenerEnd(int value, int status) {
        if (log.isDebugEnabled()) {
            log.debug("TamsOpsModeProgrammer adds 200mSec delay to response");
        }
        try {
            this.wait(200L);
        }
        catch (InterruptedException e) {
            log.debug("unexpected exception", (Throwable)e);
        }
        super.notifyProgListenerEnd(value, status);
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.OPSBYTEMODE);
        return ret;
    }

    @Override
    public boolean getCanRead() {
        return false;
    }

    @Override
    public boolean getLongAddress() {
        return this.mLongAddr;
    }

    @Override
    public int getAddressNumber() {
        return this.mAddress;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }

    @Override
    void cleanup() {
    }
}

