/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams;

import java.util.Hashtable;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.tams.TamsListener;
import jmri.jmrix.tams.TamsMessage;
import jmri.jmrix.tams.TamsReply;
import jmri.jmrix.tams.TamsSensor;
import jmri.jmrix.tams.TamsSystemConnectionMemo;
import jmri.jmrix.tams.TamsTrafficController;
import jmri.managers.AbstractSensorManager;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamsSensorManager
extends AbstractSensorManager
implements TamsListener {
    public int maxSE;
    private final Hashtable<Integer, Hashtable<Integer, TamsSensor>> _ttams = new Hashtable();
    int board = 0;
    int port = 0;
    private static final Logger log = LoggerFactory.getLogger(TamsSensorManager.class);

    public TamsSensorManager(TamsSystemConnectionMemo memo) {
        super(memo);
        this.init();
    }

    private void init() {
        TamsTrafficController tc = this.getMemo().getTrafficController();
        tc.addTamsListener(this);
        TamsMessage tm = TamsMessage.setXSR();
        tc.sendTamsMessage(tm, this);
        log.debug("Sending TamsMessage = {} , isBinary = {} and replyType = {}", new Object[]{tm.toString(), tm.isBinary(), Character.valueOf(tm.getReplyType())});
        tm = TamsMessage.getXEvtSen();
        tc.addPollMessage(tm, this);
        log.debug("TamsMessage added to poll queue = {} {} and replyType = {}", new Object[]{StringUtil.appendTwoHexFromInt(tm.getElement(0) & 0xFF, ""), StringUtil.appendTwoHexFromInt(tm.getElement(1) & 0xFF, ""), Character.valueOf(tm.getReplyType())});
    }

    @Override
    @Nonnull
    public TamsSystemConnectionMemo getMemo() {
        return (TamsSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        TamsTrafficController tc = this.getMemo().getTrafficController();
        TamsSensor s = new TamsSensor(systemName, userName);
        log.debug("Creating new TamsSensor: {}", (Object)systemName);
        if (systemName.contains(":")) {
            int board;
            String curAddress = systemName.substring(this.getSystemPrefix().length() + 1);
            int seperator = curAddress.indexOf(58);
            try {
                board = Integer.parseInt(curAddress.substring(0, seperator));
                log.debug("Creating new TamsSensor with board: {}", (Object)board);
                if (!this._ttams.containsKey(board)) {
                    this._ttams.put(board, new Hashtable());
                }
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Unable to convert " + systemName.substring(this.getSystemPrefix().length() + 1) + " into the Module and port format of nn:xx");
            }
            Hashtable<Integer, TamsSensor> sensorList = this._ttams.get(board);
            try {
                int channel = Integer.parseInt(curAddress.substring(seperator + 1));
                if (!sensorList.containsKey(channel)) {
                    sensorList.put(channel, s);
                }
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Unable to convert " + systemName.substring(this.getSystemPrefix().length() + 1) + " into the Module and port format of nn:xx");
            }
            if (board * 2 > this.maxSE) {
                this.maxSE = board * 2;
                log.debug("Changed xSE to {}", (Object)this.maxSE);
                TamsMessage tm = new TamsMessage("xSE " + Integer.toString(this.maxSE));
                tm.setBinary(false);
                tm.setReplyType('S');
                tc.sendTamsMessage(tm, this);
            }
        }
        TamsMessage tm = TamsMessage.setXSensOff();
        tc.sendTamsMessage(tm, this);
        tm = TamsMessage.getXEvtSen();
        tc.sendTamsMessage(tm, this);
        log.debug("Returning this sensor: {}", (Object)s.toString());
        return s;
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        if (!curAddress.contains(":")) {
            throw new JmriException("Hardware Address passed should be past in the form 'Module:port', was " + curAddress);
        }
        int seperator = curAddress.indexOf(58);
        try {
            this.board = Integer.parseInt(curAddress.substring(0, seperator));
        }
        catch (NumberFormatException ex) {
            throw new JmriException("First part of " + curAddress + " in front of : should be a number");
        }
        try {
            this.port = Integer.parseInt(curAddress.substring(seperator + 1));
        }
        catch (NumberFormatException ex) {
            throw new JmriException("Port Address, Second part of " + curAddress + " after : should be a number");
        }
        if (this.port == 0 || this.port > 16) {
            throw new JmriException("Port number in " + curAddress + " must be between 1 and 16");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSystemPrefix());
        sb.append("S");
        sb.append(this.board);
        sb.append(":");
        this.padPortNumber(this.port, sb);
        return sb.toString();
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateTrimmedMin1NumberSystemNameFormat(name, locale);
    }

    void padPortNumber(int portNo, StringBuilder sb) {
        if (portNo < 10) {
            sb.append("0");
        }
        sb.append(portNo);
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public void reply(TamsReply r) {
        if (this.getMemo().getTrafficController().replyType == 'S') {
            log.debug("*** Tams Sensor Reply ***");
            if (this.getMemo().getTrafficController().replyBinary) {
                log.debug("Reply to binary command = {}", (Object)r);
                if (r.getNumDataElements() > 1 && r.getElement(0) > 0) {
                    int numberOfReplies = r.getNumDataElements() / 3;
                    for (int i = 0; i < numberOfReplies; ++i) {
                        TamsReply tr = new TamsReply();
                        tr.setBinary(true);
                        tr.setElement(0, r.getElement(3 * i));
                        tr.setElement(1, r.getElement(3 * i + 1));
                        tr.setElement(2, r.getElement(3 * i + 2));
                        log.debug("Going to pass this to the decoder = {} {} {}", new Object[]{tr.getElement(0), tr.getElement(1), tr.getElement(2)});
                        this.decodeSensorState(tr);
                    }
                }
            }
        }
    }

    @Override
    public void message(TamsMessage m) {
    }

    private void decodeSensorState(TamsReply r) {
        String sensorprefix = this.getSystemPrefix() + "S" + r.getElement(0) + ":";
        log.debug("Decoding sensor: {}", (Object)sensorprefix);
        log.debug("Lower Byte: {}", (Object)r.getElement(1));
        log.debug("Upper Byte: {}", (Object)r.getElement(2));
        Hashtable<Integer, TamsSensor> sensorList = this._ttams.get(this.board);
        int i = (r.getElement(1) & 0xFF) << 8;
        log.debug("i after loading first byte= {}", (Object)Integer.toString(i, 2));
        log.debug("i after loading second byte= {}", (Object)Integer.toString(i += r.getElement(2) & 0xFF, 2));
        int mask = 32768;
        for (int j = 1; j <= 16; ++j) {
            int result = i & mask;
            if (sensorList != null) {
                TamsSensor ms = sensorList.get(j);
                log.debug("ms: {}", (Object)ms);
                if (ms == null) {
                    log.debug("ms = NULL!");
                    StringBuilder sb = new StringBuilder();
                    sb.append(sensorprefix);
                    this.padPortNumber(j, sb);
                    try {
                        ms = (TamsSensor)this.provideSensor(sb.toString());
                    }
                    catch (Exception e) {
                        log.warn("Could not provide Sensor {}: {}", (Object)sb.toString(), (Object)e.getLocalizedMessage());
                    }
                }
                if (ms != null) {
                    log.debug("ms = exists and is not null");
                    if (result == 0) {
                        ms.setOwnState(4);
                        log.debug("{}{} INACTIVE", (Object)sensorprefix, (Object)j);
                    } else {
                        log.debug("{}{} ACTIVE", (Object)sensorprefix, (Object)j);
                        ms.setOwnState(2);
                    }
                }
            }
            mask /= 2;
        }
        log.debug("sensor decoding is done");
    }

    @Override
    public void dispose() {
        this.getMemo().getTrafficController().removePollMessage(TamsMessage.getXEvtSen(), this);
        this.getMemo().getTrafficController().removeTamsListener(this);
        super.dispose();
    }
}

