/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedList;
import java.util.Queue;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.tams.TamsListener;
import jmri.jmrix.tams.TamsMessage;
import jmri.jmrix.tams.TamsReply;
import jmri.jmrix.tams.TamsSystemConnectionMemo;
import jmri.jmrix.tams.TamsTrafficController;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamsThrottle
extends AbstractThrottle
implements TamsListener {
    private final Queue<TamsMessage> tmq = new LinkedList<TamsMessage>();
    private final DccLocoAddress address;
    TamsTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(TamsThrottle.class);

    private static TamsMessage myDummy() {
        log.trace("*** myDummy ***");
        TamsMessage m = new TamsMessage(2);
        m.setElement(0, 0);
        m.setElement(1, 201);
        m.setBinary(true);
        m.setReplyOneByte(false);
        m.setReplyType('L');
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TamsThrottle(TamsSystemConnectionMemo memo, DccLocoAddress address) {
        super(memo);
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
        this.tc = memo.getTrafficController();
        TamsThrottle tamsThrottle = this;
        synchronized (tamsThrottle) {
            this.speedSetting = 0.0f;
        }
        this.address = address;
        this.isForward = true;
        TamsMessage tm = new TamsMessage("xL " + address.getNumber());
        tm.setTimeout(10000);
        tm.setBinary(false);
        tm.setReplyType('L');
        this.tc.sendTamsMessage(tm, this);
        this.tmq.add(tm);
        tm = new TamsMessage("xF " + address.getNumber());
        tm.setBinary(false);
        tm.setReplyType('L');
        this.tc.sendTamsMessage(tm, this);
        this.tmq.add(tm);
        tm = new TamsMessage("xFX " + address.getNumber());
        tm.setBinary(false);
        tm.setReplyType('L');
        this.tc.sendTamsMessage(tm, this);
        this.tmq.add(tm);
        tm = TamsMessage.getXEvtLok();
        this.tc.sendTamsMessage(tm, this);
        this.tmq.add(tm);
        this.tc.addPollMessage(tm, this);
    }

    @Override
    protected void sendFunctionGroup1() {
        StringBuilder sb = new StringBuilder();
        sb.append("xL ");
        sb.append(this.address.getNumber());
        sb.append(",");
        sb.append(",");
        sb.append(this.getFunction(0) ? "1" : "0");
        sb.append(",");
        sb.append(",");
        sb.append(this.getFunction(1) ? "1" : "0");
        sb.append(",");
        sb.append(this.getFunction(2) ? "1" : "0");
        sb.append(",");
        sb.append(this.getFunction(3) ? "1" : "0");
        sb.append(",");
        sb.append(this.getFunction(4) ? "1" : "0");
        TamsMessage tm = new TamsMessage(sb.toString());
        tm.setBinary(false);
        tm.setReplyType('L');
        this.tc.sendTamsMessage(tm, this);
        this.tmq.add(tm);
    }

    @Override
    protected void sendFunctionGroup2() {
        StringBuilder sb = new StringBuilder();
        sb.append("xF ");
        sb.append(this.address.getNumber());
        sb.append(",");
        sb.append(",");
        sb.append(",");
        sb.append(",");
        sb.append(",");
        sb.append(this.getFunction(5) ? "1" : "0");
        sb.append(",");
        sb.append(this.getFunction(6) ? "1" : "0");
        sb.append(",");
        sb.append(this.getFunction(7) ? "1" : "0");
        sb.append(",");
        sb.append(this.getFunction(8) ? "1" : "0");
        TamsMessage tm = new TamsMessage(sb.toString());
        tm.setBinary(false);
        tm.setReplyType('T');
        this.tc.sendTamsMessage(tm, this);
        this.tmq.add(tm);
    }

    @Override
    protected void sendFunctionGroup3() {
        StringBuilder sb = new StringBuilder();
        sb.append("xFX ");
        sb.append(this.address.getNumber());
        sb.append(",");
        sb.append(this.getFunction(9) ? "1" : "0");
        sb.append(",");
        sb.append(this.getFunction(10) ? "1" : "0");
        sb.append(",");
        sb.append(this.getFunction(11) ? "1" : "0");
        sb.append(",");
        sb.append(this.getFunction(12) ? "1" : "0");
        TamsMessage tm = new TamsMessage(sb.toString());
        tm.setBinary(false);
        tm.setReplyType('L');
        this.tc.sendTamsMessage(tm, this);
        this.tmq.add(tm);
    }

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public synchronized void setSpeedSetting(float speed) {
        float oldSpeed = this.speedSetting;
        this.speedSetting = speed;
        int value = Math.round(126.0f * this.speedSetting);
        if (this.speedSetting > 0.0f && value == 0) {
            value = 1;
        }
        if (value > 0) {
            ++value;
        }
        if (value > 127) {
            value = 127;
        }
        if (value < 0) {
            value = 1;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("xL ");
        sb.append(this.address.getNumber());
        sb.append(",");
        sb.append(value);
        sb.append(",");
        sb.append(",");
        sb.append(this.isForward ? "f" : "r");
        sb.append(",");
        sb.append(",");
        sb.append(",");
        sb.append(",");
        TamsMessage tm = new TamsMessage(sb.toString());
        tm.setBinary(false);
        tm.setReplyType('L');
        this.tc.sendTamsMessage(tm, this);
        this.tmq.add(tm);
        this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        this.record(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        TamsThrottle tamsThrottle = this;
        synchronized (tamsThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    public void throttleDispose() {
        this.active = false;
        TamsMessage tm = TamsMessage.getXEvtLok();
        this.tc.removePollMessage(tm, this);
        this.finishRecord();
    }

    @Override
    public void message(TamsMessage m) {
    }

    protected float floatSpeed(int lSpeed) {
        if (lSpeed == 0) {
            return 0.0f;
        }
        if (lSpeed == 1) {
            return -1.0f;
        }
        if (this.speedStepMode == SpeedStepMode.NMRA_DCC_128) {
            return (float)(lSpeed - 1) / 126.0f;
        }
        return (int)((double)((float)lSpeed * 27.0f) + 0.5) + 1;
    }

    @Override
    public void reply(TamsReply tr) {
        TamsMessage tm;
        log.trace("*** Loco reply ***");
        TamsMessage tamsMessage = tm = this.tmq.isEmpty() ? TamsThrottle.myDummy() : this.tmq.poll();
        if (tm.isBinary()) {
            int msb = tr.getElement(3) & 0x3F;
            int lsb = tr.getElement(2) & 0xFF;
            int receivedAddress = msb * 256 + lsb;
            if (log.isTraceEnabled()) {
                log.trace("reply for loco = {}", (Object)receivedAddress);
                log.trace("reply = {} {} {} {} {}", new Object[]{StringUtil.appendTwoHexFromInt(tr.getElement(4) & 0xFF, ""), StringUtil.appendTwoHexFromInt(tr.getElement(3) & 0xFF, ""), StringUtil.appendTwoHexFromInt(tr.getElement(2) & 0xFF, ""), StringUtil.appendTwoHexFromInt(tr.getElement(1) & 0xFF, ""), StringUtil.appendTwoHexFromInt(tr.getElement(0) & 0xFF, "")});
            }
            if (receivedAddress == this.address.getNumber()) {
                log.trace("Is my address");
                try {
                    StringBuilder sb = new StringBuilder();
                    Float newSpeed = Float.valueOf(this.floatSpeed(tr.getElement(0)));
                    super.setSpeedSetting(newSpeed.floatValue());
                    log.trace("f0 = {}", (Object)(tr.getElement(3) & 0x40));
                    this.appendFuncString(0, sb, (tr.getElement(3) & 0x40) == 64);
                    if ((tr.getElement(3) & 0x80) == 0 && this.isForward) {
                        this.isForward = false;
                        this.firePropertyChange("IsForward", true, this.isForward);
                    }
                    if ((tr.getElement(3) & 0x80) == 128 && !this.isForward) {
                        this.isForward = true;
                        this.firePropertyChange("IsForward", false, this.isForward);
                    }
                    this.appendFuncString(1, sb, (tr.getElement(1) & 1) == 1);
                    this.appendFuncString(2, sb, (tr.getElement(1) & 2) == 2);
                    this.appendFuncString(3, sb, (tr.getElement(1) & 4) == 4);
                    this.appendFuncString(4, sb, (tr.getElement(1) & 8) == 8);
                    this.appendFuncString(5, sb, (tr.getElement(1) & 0x10) == 16);
                    this.appendFuncString(6, sb, (tr.getElement(1) & 0x20) == 32);
                    this.appendFuncString(7, sb, (tr.getElement(1) & 0x40) == 64);
                    this.appendFuncString(8, sb, (tr.getElement(1) & 0x80) == 128);
                    log.trace("Functions: {}", (Object)sb);
                }
                catch (RuntimeException ex) {
                    log.error("Error handling reply from MC", (Throwable)ex);
                }
            }
        } else {
            if (tr.match("WARNING") >= 0) {
                return;
            }
            if (tr.match("L " + this.address.getNumber()) >= 0) {
                try {
                    log.trace("ASCII address = {}", (Object)this.address.getNumber());
                    String[] lines = tr.toString().split(" ");
                    Float newSpeed = Float.valueOf(this.floatSpeed(Integer.parseInt(lines[2])));
                    super.setSpeedSetting(newSpeed.floatValue());
                    this.updateFunction(0, lines[3].equals("1"));
                    if (lines[4].equals("r") && this.isForward) {
                        this.isForward = false;
                        this.firePropertyChange("IsForward", true, this.isForward);
                    } else if (lines[4].equals("f") && !this.isForward) {
                        this.isForward = true;
                        this.firePropertyChange("IsForward", false, this.isForward);
                    }
                    this.updateFunction(1, lines[5].equals("1"));
                    this.updateFunction(2, lines[6].equals("1"));
                    this.updateFunction(3, lines[7].equals("1"));
                    this.updateFunction(4, lines[8].equals("1"));
                }
                catch (NumberFormatException ex) {
                    log.error("Error phrasing reply from MC", (Throwable)ex);
                }
            } else if (tr.match("FX " + this.address.getNumber()) >= 0) {
                String[] lines = tr.toString().split(" ");
                try {
                    this.updateFunction(9, lines[2].equals("1"));
                    this.updateFunction(10, lines[3].equals("1"));
                    this.updateFunction(11, lines[4].equals("1"));
                    this.updateFunction(12, lines[5].equals("1"));
                    this.updateFunction(13, lines[6].equals("1"));
                    this.updateFunction(14, lines[7].equals("1"));
                }
                catch (RuntimeException ex) {
                    log.error("Error phrasing reply from MC", (Throwable)ex);
                }
            } else if (tr.match("F " + this.address.getNumber()) >= 0) {
                String[] lines = tr.toString().split(" ");
                try {
                    this.updateFunction(1, lines[2].equals("1"));
                    this.updateFunction(2, lines[3].equals("1"));
                    this.updateFunction(3, lines[4].equals("1"));
                    this.updateFunction(4, lines[5].equals("1"));
                    this.updateFunction(5, lines[6].equals("1"));
                    this.updateFunction(6, lines[7].equals("1"));
                    this.updateFunction(7, lines[8].equals("1"));
                    this.updateFunction(8, lines[9].equals("1"));
                }
                catch (RuntimeException ex) {
                    log.error("Error phrasing reply from MC", (Throwable)ex);
                }
            } else if (tr.toString().equals("ERROR: no data.")) {
                log.debug("Loco has no data");
            }
        }
    }

    private void appendFuncString(int Fn, StringBuilder sb, boolean value) {
        this.updateFunction(Fn, value);
        if (this.getFunction(Fn)) {
            sb.append("f");
            sb.append(String.valueOf(Fn));
        } else {
            sb.append(String.valueOf(Fn));
            sb.append("f");
        }
        if (Fn < 8) {
            sb.append(" ");
        }
    }
}

