/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams;

import java.util.EnumSet;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.tams.TamsListener;
import jmri.jmrix.tams.TamsMessage;
import jmri.jmrix.tams.TamsReply;
import jmri.jmrix.tams.TamsSystemConnectionMemo;
import jmri.jmrix.tams.TamsThrottle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamsThrottleManager
extends AbstractThrottleManager
implements TamsListener {
    private static TamsThrottleManager mInstance = null;
    private static final Logger log = LoggerFactory.getLogger(TamsThrottleManager.class);

    public TamsThrottleManager(TamsSystemConnectionMemo memo) {
        super(memo);
    }

    public static TamsThrottleManager instance() {
        return mInstance;
    }

    @Override
    public void reply(TamsReply m) {
    }

    @Override
    public void message(TamsMessage m) {
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        if (address instanceof DccLocoAddress) {
            log.info("new TamsThrottle for {}", (Object)address);
            this.notifyThrottleKnown(new TamsThrottle((TamsSystemConnectionMemo)this.adapterMemo, (DccLocoAddress)address), address);
        } else {
            log.error("{} is not a DccLocoAddress", (Object)address);
            this.failedThrottleRequest(address, "LocoAddress " + address + " is not a DccLocoAddress");
        }
    }

    @Override
    public boolean hasDispatchFunction() {
        return false;
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return TamsThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return !TamsThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean addressTypeUnique() {
        return true;
    }

    @Override
    protected boolean singleUse() {
        return false;
    }

    static boolean isLongAddress(int num) {
        return num >= 100;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128, SpeedStepMode.NMRA_DCC_28);
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        if (super.disposeThrottle(t, l) && t instanceof TamsThrottle) {
            TamsThrottle lnt = (TamsThrottle)t;
            lnt.throttleDispose();
            return true;
        }
        return false;
    }
}

