/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.tams.TamsListener;
import jmri.jmrix.tams.TamsMessage;
import jmri.jmrix.tams.TamsReply;
import jmri.jmrix.tams.TamsTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamsTurnout
extends AbstractTurnout
implements TamsListener {
    static String[] modeNames = null;
    static int[] modeValues = null;
    private final TamsTrafficController tc;
    int _number;
    private static final Logger log = LoggerFactory.getLogger(TamsTurnout.class);

    public TamsTurnout(int number, String prefix, TamsTrafficController etc) {
        super(prefix + "T" + number);
        this._number = number;
        this.tc = etc;
        TamsMessage m = new TamsMessage("xT " + this._number + ",,0");
        m.setBinary(false);
        m.setReplyType('T');
        this.tc.sendTamsMessage(m, this);
        this._validFeedbackTypes |= 8;
        this._activeFeedbackType = 8;
        if (modeNames == null) {
            this.initFeedbackModes();
        }
        this._validFeedbackNames = modeNames;
        this._validFeedbackModes = modeValues;
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Only used during creation of 1st turnout")
    private void initFeedbackModes() {
        log.debug("*** initFeedbackModes ***");
        if (this._validFeedbackNames.length != this._validFeedbackModes.length) {
            log.error("int and string feedback arrays different length");
        }
        String[] tempModeNames = new String[this._validFeedbackNames.length + 1];
        int[] tempModeValues = new int[this._validFeedbackNames.length + 1];
        for (int i = 0; i < this._validFeedbackNames.length; ++i) {
            tempModeNames[i] = this._validFeedbackNames[i];
            tempModeValues[i] = this._validFeedbackModes[i];
        }
        tempModeNames[this._validFeedbackNames.length] = "MONITORING";
        tempModeValues[this._validFeedbackNames.length] = 8;
        modeNames = tempModeNames;
        modeValues = tempModeValues;
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        log.debug("*** forwardCommandChangeToLayout ***");
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both CLOSED and THROWN {}", (Object)newState);
            } else {
                this.sendMessage(!this.getInverted());
            }
        } else {
            this.sendMessage(this.getInverted());
        }
    }

    synchronized void setCommandedStateFromCS(int state) {
        log.debug("*** setCommandedStateFromCS ***");
        if (this.getFeedbackMode() != 8) {
            log.debug("Returning");
            return;
        }
        log.debug("Setting to state {}", (Object)state);
        this.newCommandedState(state);
    }

    synchronized void setKnownStateFromCS(int state) {
        log.debug("*** setKnownStateFromCS ***");
        if (this.getFeedbackMode() != 8) {
            return;
        }
        this.newKnownState(state);
    }

    @Override
    public void turnoutPushbuttonLockout(boolean b) {
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    protected void sendMessage(boolean closed) {
        log.debug("*** sendMessage ***");
        TamsMessage m = new TamsMessage("xT " + this._number + "," + (closed ? "r" : "g") + ",1");
        this.tc.sendTamsMessage(m, this);
    }

    @Override
    public void reply(TamsReply m) {
        String[] lines;
        log.debug("*** TamsReply ***");
        log.debug("m.match(\"T\") = {}", (Object)Integer.toString(m.match("T")));
        String msg = m.toString();
        log.debug("Turnout Reply = {}", (Object)msg);
        if (m.match("T") == 0 && (lines = msg.split(" "))[1].equals("" + this._number)) {
            if (lines[2].equals("r") || lines[2].equals("0")) {
                log.debug("Turnout {} = CLOSED", (Object)this._number);
                this.setCommandedStateFromCS(2);
                this.setKnownStateFromCS(2);
            } else {
                log.debug("Turnout {} = THROWN", (Object)this._number);
                this.setCommandedStateFromCS(4);
                this.setKnownStateFromCS(4);
            }
        }
    }

    @Override
    public void setFeedbackMode(int mode) throws IllegalArgumentException {
        log.debug("*** setFeedbackMode ***");
        TamsMessage m = new TamsMessage("xT " + this._number + ",,1");
        if (mode == 8) {
            this.tc.sendTamsMessage(m, this);
        }
        super.setFeedbackMode(mode);
    }

    @Override
    public void message(TamsMessage m) {
        log.debug("*** message ***");
    }

    @Override
    public void dispose() {
        log.debug("*** dispose ***");
        TamsMessage m = new TamsMessage("xT " + this._number + ",,1");
        this.tc.removePollMessage(m, this);
        super.dispose();
    }
}

