/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.jmrix.tams.TamsListener;
import jmri.jmrix.tams.TamsMessage;
import jmri.jmrix.tams.TamsReply;
import jmri.jmrix.tams.TamsSystemConnectionMemo;
import jmri.jmrix.tams.TamsTrafficController;
import jmri.jmrix.tams.TamsTurnout;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamsTurnoutManager
extends AbstractTurnoutManager
implements TamsListener {
    boolean noWarnDelete = false;
    private static final Logger log = LoggerFactory.getLogger(TamsTurnoutManager.class);

    public TamsTurnoutManager(TamsSystemConnectionMemo memo) {
        super(memo);
        TamsMessage m = TamsMessage.getXEvtTrn();
        memo.getTrafficController().sendTamsMessage(m, this);
        memo.getTrafficController().addPollMessage(m, this);
    }

    @Override
    @Nonnull
    public TamsSystemConnectionMemo getMemo() {
        return (TamsSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException e) {
            log.error("failed to convert systemName {} to a turnout address", (Object)systemName);
            throw new IllegalArgumentException("Failed to convert systemName '" + systemName + "' to a Turnout address");
        }
        TamsTurnout t = new TamsTurnout(addr, this.getSystemPrefix(), this.getMemo().getTrafficController());
        t.setUserName(userName);
        return t;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateTrimmedMin1NumberSystemNameFormat(name, locale);
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public void message(TamsMessage m) {
    }

    @Override
    public void reply(TamsReply r) {
        if (this.getMemo().getTrafficController().replyType == 'T') {
            log.debug("*** Tams Turnout Reply ***");
            if (this.getMemo().getTrafficController().replyBinary) {
                log.debug("Reply to binary command = {}", (Object)r.toString());
                if (r.getNumDataElements() > 1 && r.getElement(0) > 0 && r.getElement(0) != 84) {
                    for (int i = 1; i < r.getNumDataElements() - 1; i += 2) {
                        TamsReply tr = new TamsReply();
                        tr.setBinary(true);
                        tr.setElement(0, r.getElement(i));
                        tr.setElement(1, r.getElement(i + 1));
                        log.debug("Going to pass this to the decoder = {}", (Object)tr.toString());
                        this.decodeTurnoutState(tr, this.getSystemPrefix(), this.getMemo().getTrafficController());
                    }
                }
            } else {
                log.debug("Reply to ASCII command = {}", (Object)r.toString());
            }
        }
    }

    void decodeTurnoutState(TamsReply r, String prefix, TamsTrafficController tc) {
        int lowerByte = r.getElement(0) & 0xFF;
        int upperByte = r.getElement(1) & 0xFF;
        log.debug("Decoding turnout");
        int turnoutAddress = (upperByte & 7) * 256 + lowerByte;
        String turnoutName = prefix + "T" + Integer.toString(turnoutAddress);
        int turnoutState = 4;
        if ((upperByte & 0x80) == 128) {
            turnoutState = 2;
        }
        log.debug("Turnout Address: -{}-, state: {}", (Object)turnoutName, (Object)turnoutState);
        TamsTurnout ttu = (TamsTurnout)this.provideTurnout(turnoutName);
        ttu.setCommandedStateFromCS(turnoutState);
        ttu.setKnownStateFromCS(turnoutState);
    }

    @Override
    public void dispose() {
        this.getMemo().getTrafficController().removePollMessage(TamsMessage.getXEvtTrn(), this);
        super.dispose();
    }
}

