/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams.simulator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import jmri.jmrix.tams.TamsMessage;
import jmri.jmrix.tams.TamsPortController;
import jmri.jmrix.tams.TamsReply;
import jmri.jmrix.tams.TamsSystemConnectionMemo;
import jmri.jmrix.tams.TamsTrafficController;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatorAdapter
extends TamsPortController
implements Runnable {
    private Thread sourceThread;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private static final Logger log = LoggerFactory.getLogger(SimulatorAdapter.class);

    public SimulatorAdapter() {
        super(new TamsSystemConnectionMemo());
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
        }
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        TamsTrafficController tc = new TamsTrafficController();
        tc.connectPort(this);
        this.getSystemConnectionMemo().setTamsTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().configureManagers();
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("Tams Simulator");
        this.sourceThread.setPriority(1);
        this.sourceThread.start();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened || this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
        }
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened || this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
        }
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        log.debug("validBaudRates should not have been invoked");
        return new String[0];
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[0];
    }

    @Override
    public String getCurrentBaudRate() {
        return "";
    }

    @Override
    public String getCurrentPortName() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (log.isInfoEnabled()) {
            log.info("TAMS Simulator Started");
        }
        while (true) {
            int i;
            StringBuilder buf;
            try {
                SimulatorAdapter simulatorAdapter = this;
                synchronized (simulatorAdapter) {
                    this.wait(50L);
                }
            }
            catch (InterruptedException e) {
                log.debug("interrupted, ending");
                return;
            }
            TamsMessage m = this.readMessage();
            if (log.isDebugEnabled()) {
                buf = new StringBuilder();
                if (m != null) {
                    for (i = 0; i < m.getNumDataElements(); ++i) {
                        buf.append(Integer.toHexString(0xFF & m.getElement(i))).append(" ");
                    }
                } else {
                    buf.append("null message buffer");
                }
                log.debug("Tams Simulator Thread received message: {}", (Object)buf);
            }
            if (m == null) continue;
            TamsReply r = this.generateReply(m);
            this.writeReply(r);
            if (!log.isDebugEnabled()) continue;
            buf = new StringBuilder();
            for (i = 0; i < r.getNumDataElements(); ++i) {
                buf.append(Integer.toHexString(0xFF & r.getElement(i))).append(" ");
            }
            log.debug("Tams Simulator Thread sent reply: {}", (Object)buf);
        }
    }

    private TamsMessage readMessage() {
        TamsMessage msg = null;
        try {
            if (this.inpipe.available() > 0) {
                msg = this.loadChars();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return msg;
    }

    private TamsMessage loadChars() throws IOException {
        byte[] rcvBuffer = new byte[32];
        int nchars = this.inpipe.read(rcvBuffer, 0, 32);
        TamsMessage msg = new TamsMessage(nchars);
        for (int i = 0; i < nchars; ++i) {
            msg.setElement(i, rcvBuffer[i] & 0xFF);
        }
        return msg;
    }

    private TamsReply generateReply(TamsMessage m) {
        TamsReply reply = new TamsReply();
        int i = 0;
        log.debug("Rec {}", (Object)m.toString());
        if (m.toString().startsWith("xY")) {
            reply.setElement(i++, 0);
        } else if (m.toString().startsWith("xSR")) {
            reply.setElement(i++, 83);
            reply.setElement(i++, 82);
            reply.setElement(i++, 32);
            reply.setElement(i++, m.getElement(3));
        } else if (m.getElement(0) == 153) {
            reply.setElement(i++, 85);
            reply.setElement(i++, 85);
            reply.setElement(i++, 170);
            reply.setElement(i++, 170);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
            reply.setElement(i++, 0);
        }
        reply.setElement(i++, 13);
        reply.setElement(i++, 93);
        return reply;
    }

    private void writeReply(TamsReply r) {
        if (r == null) {
            return;
        }
        for (int i = 0; i < r.getNumDataElements(); ++i) {
            try {
                this.outpipe.writeByte((byte)r.getElement(i));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.outpipe.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

